/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.GreekFantasy;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class SimpleTemplateFeature
extends Feature<NoFeatureConfig> {
    public SimpleTemplateFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    protected abstract ResourceLocation getStructure(Random var1);

    protected boolean isValidPosition(ISeedReader reader, BlockPos pos, BlockPos size, Rotation r) {
        BlockPos c1 = pos;
        BlockPos c4 = pos.func_177971_a((Vector3i)new BlockPos(-size.func_177958_n(), 0, -size.func_177952_p()).func_190942_a(r));
        return this.isValidPosition(reader, c1) && this.isValidPosition(reader, c4);
    }

    protected boolean isValidPosition(ISeedReader reader, BlockPos pos) {
        return pos.func_177956_o() > 3 && reader.func_180495_p(pos).func_200132_m() && SimpleTemplateFeature.isReplaceableAt((IWorldGenerationReader)reader, pos.func_177981_b(1));
    }

    public static boolean isPlantAt(IWorldGenerationReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Material m = state.func_185904_a();
            return m == Material.field_151582_l || m == Material.field_151585_k;
        });
    }

    protected static boolean isReplaceableAt(IWorldGenerationReader reader, BlockPos pos) {
        return SimpleTemplateFeature.func_236297_b_((IWorldGenerationBaseReader)reader, (BlockPos)pos) || SimpleTemplateFeature.isPlantAt(reader, pos);
    }

    public static BlockPos getRandomPosition(ISeedReader reader, BlockPos origin, Random rand, int down) {
        BlockPos blockPos = origin.func_177982_a(4 + rand.nextInt(8), 0, 4 + rand.nextInt(8));
        return SimpleTemplateFeature.getHeightPos(reader, blockPos);
    }

    public static BlockPos getHeightPos(ISeedReader world, BlockPos original) {
        int y = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, original).func_177956_o();
        BlockPos pos = new BlockPos(original.func_177958_n(), y, original.func_177952_p());
        return world.func_180495_p(pos).func_203425_a(Blocks.field_150433_aE) ? pos.func_177979_c(2) : pos.func_177977_b();
    }

    public static void fillBelow(ISeedReader world, BlockPos origin, BlockPos size, Rotation rotation, Block[] blocks) {
        int lx = size.func_177958_n();
        for (int dx = 0; dx < lx; ++dx) {
            int lz = size.func_177952_p();
            for (int dz = 0; dz < lz; ++dz) {
                BlockPos tmp = new BlockPos(dx, 0, dz).func_190942_a(rotation);
                BlockPos pos = origin.func_177971_a((Vector3i)tmp);
                if (!world.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) || !world.func_180495_p(pos.func_177984_a()).func_200132_m()) continue;
                while (pos.func_177956_o() > 0 && SimpleTemplateFeature.isReplaceableAt((IWorldGenerationReader)world, pos)) {
                    Block block = blocks[world.func_201674_k().nextInt(blocks.length)];
                    world.func_180501_a(pos, block.func_176223_P(), 2);
                    pos = pos.func_177977_b();
                }
            }
        }
    }

    public static boolean isValidDimension(ISeedReader world) {
        String dimName = world.func_201672_e().func_234923_W_().func_240901_a_().toString();
        return ((Boolean)GreekFantasy.CONFIG.IS_FEATURES_WHITELIST.get()).booleanValue() == ((List)GreekFantasy.CONFIG.FEATURES_DIMENSION_WHITELIST.get()).contains(dimName);
    }
}

