/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallNetherShrineFeature
extends SimpleTemplateFeature {
    private static final ResourceLocation STRUCTURE = new ResourceLocation("greekfantasy", "small_nether_shrine");

    public SmallNetherShrineFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        Template template = manager.func_200220_a(STRUCTURE);
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        Optional<BlockPos> optionalPos = this.getRandomPositionInChunk(reader, blockPosIn, template.func_186259_a(), 2, rand, rotation);
        if (!optionalPos.isPresent()) {
            return false;
        }
        BlockPos pos = optionalPos.get();
        MutableBoundingBox mbb = new MutableBoundingBox(pos.func_177958_n() - 8, pos.func_177956_o() - 16, pos.func_177952_p() - 8, pos.func_177958_n() + 8, pos.func_177956_o() + 16, pos.func_177952_p() + 8);
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_186223_a(mbb).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        return template.func_237146_a_((IServerWorld)reader, pos, pos, placement, rand, 2);
    }

    private Optional<BlockPos> getRandomPositionInChunk(ISeedReader reader, BlockPos blockPosIn, BlockPos size, int down, Random rand, Rotation r) {
        for (int i = 0; i < 8; ++i) {
            BlockPos pos = new BlockPos(blockPosIn.func_177958_n() + 4 + rand.nextInt(8), 32 + rand.nextInt(88), blockPosIn.func_177952_p() + 4 + rand.nextInt(8));
            if (!this.isValidPosition(reader, pos, size, r)) continue;
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    @Override
    protected ResourceLocation getStructure(Random rand) {
        return STRUCTURE;
    }
}

