/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallShrineFeature
extends SimpleTemplateFeature {
    private static final ResourceLocation STRUCTURE_LIMESTONE = new ResourceLocation("greekfantasy", "small_limestone_shrine");
    private static final ResourceLocation STRUCTURE_MARBLE = new ResourceLocation("greekfantasy", "small_marble_shrine");

    public SmallShrineFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        Template template = manager.func_200220_a(this.getStructure(rand));
        BlockPos pos = SmallShrineFeature.getRandomPosition(reader, blockPosIn, rand, 1);
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        BlockPos size = template.func_186259_a();
        if (!this.isValidPosition(reader, pos, size, rotation)) {
            return false;
        }
        MutableBoundingBox mbb = new MutableBoundingBox(pos.func_177958_n() - 8, pos.func_177956_o() - 16, pos.func_177952_p() - 8, pos.func_177958_n() + 8, pos.func_177956_o() + 16, pos.func_177952_p() + 8);
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_186223_a(mbb).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        if (template.func_237146_a_((IServerWorld)reader, pos, pos, placement, rand, 2)) {
            SmallShrineFeature.fillBelow(reader, pos.func_177981_b(1), size, rotation, new Block[]{Blocks.field_150346_d});
            return true;
        }
        return false;
    }

    @Override
    protected ResourceLocation getStructure(Random rand) {
        return rand.nextBoolean() ? STRUCTURE_LIMESTONE : STRUCTURE_MARBLE;
    }
}

