/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import greekfantasy.client.render.model.armor.AchillesHelmetModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AchillesArmorItem
extends ArmorItem {
    protected static final IArmorMaterial MATERIAL = new AchillesArmorMaterial();
    private static final String TEXTURE_1 = "greekfantasy:textures/models/armor/achilles_layer_1.png";
    private static final String TEXTURE_2 = "greekfantasy:textures/models/armor/achilles_layer_2.png";
    private static final String TEXTURE_3 = "greekfantasy:textures/models/armor/achilles_layer_3.png";
    @OnlyIn(value=Dist.CLIENT)
    private AchillesHelmetModel MODEL;
    public static final float ACHILLES_HEEL_BASE = 0.2f;
    public static final float ACHILLES_HEEL_BONUS = 0.15f;
    public static final float IMMUNITY_BASE = 0.0f;
    public static final float IMMUNITY_BONUS = 0.25f;

    public AchillesArmorItem(EquipmentSlotType slot, Item.Properties builderIn) {
        super(MATERIAL, slot, builderIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("enchantment.minecraft.projectile_protection").func_240702_b_(" +0.25").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.greekfantasy.achilles_armor.tooltip", new Object[]{Float.valueOf(0.15f)}).func_240699_a_(TextFormatting.GRAY));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (slot == EquipmentSlotType.HEAD) {
            return TEXTURE_3;
        }
        if (slot == EquipmentSlotType.LEGS) {
            return TEXTURE_2;
        }
        return TEXTURE_1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (armorSlot != EquipmentSlotType.HEAD) {
            return _default;
        }
        if (this.MODEL == null) {
            this.MODEL = new AchillesHelmetModel(1.0f);
        }
        this.MODEL.field_217114_e = _default.field_217114_e;
        this.MODEL.field_228270_o_ = _default.field_228270_o_;
        this.MODEL.field_217113_d = _default.field_217113_d;
        this.MODEL.func_225597_a_(entityLiving, entityLiving.field_184619_aG, entityLiving.field_70721_aZ, (float)entityLiving.field_70173_aa, entityLiving.field_70759_as, entityLiving.field_70125_A);
        return (A)((Object)this.MODEL);
    }

    public static float getProjectileCritChance(int numPieces) {
        return 0.2f + 0.15f * (float)numPieces;
    }

    public static float getProjectileImmunityChance(int numPieces) {
        return numPieces > 0 ? 0.0f + 0.25f * (float)numPieces : 0.0f;
    }

    public static class AchillesArmorMaterial
    implements IArmorMaterial {
        private static final String NAME = "achilles";

        public int func_200902_b(EquipmentSlotType slot) {
            return ArmorMaterial.IRON.func_200902_b(slot);
        }

        public int func_200896_a(EquipmentSlotType slot) {
            return ArmorMaterial.IRON.func_200896_a(slot);
        }

        public int func_200900_a() {
            return ArmorMaterial.GOLD.func_200900_a();
        }

        public float func_230304_f_() {
            return ArmorMaterial.NETHERITE.func_230304_f_();
        }

        public String func_200897_d() {
            return NAME;
        }

        public Ingredient func_200898_c() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{GFRegistry.FIERY_GEAR});
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187722_q;
        }

        public float func_200901_e() {
            return ArmorMaterial.NETHERITE.func_200901_e() + 1.0f;
        }
    }
}

