/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ClubItem
extends TieredItem
implements IVanishable {
    public static final UUID ATTACK_KNOCKBACK_MODIFIER = UUID.fromString("d5df356d-0c5c-4629-bf18-e8dcde25bcb9");
    public static final UUID MOVE_SPEED_MODIFIER = UUID.fromString("aaa7e73d-1121-45e2-8b0e-dd2042f7dddc");
    public static final double ATTACK_KNOCKBACK_AMOUNT = 1.8;
    protected final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ClubItem(IItemTier tier, Item.Properties properties) {
        super(tier, properties);
        double attackDamage = 5.5 + (double)tier.func_200929_c();
        double attackSpeed = -3.5;
        double moveSpeed = -0.1;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233824_g_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", 1.8, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(MOVE_SPEED_MODIFIER, "Weapon modifier", -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.attributeModifiers = builder.build();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(2, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        if (attacker instanceof PlayerEntity && !((PlayerEntity)attacker).func_184811_cZ().func_185141_a((Item)this)) {
            float knockback = 0.0f;
            for (AttributeModifier modifier : this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack).get((Object)Attributes.field_233824_g_)) {
                knockback = (float)((double)knockback + modifier.func_111164_d());
            }
            target.func_233627_a_(knockback * 0.75f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(equipmentSlot, stack);
    }
}

