/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GreekFantasy;
import greekfantasy.item.ThunderboltItem;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ConchItem
extends Item {
    public ConchItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack item = player.func_184586_b(handIn);
        if (!world.func_201670_d() && GreekFantasy.CONFIG.isConchEnabled()) {
            RayTraceResult raytrace = ThunderboltItem.raytraceFromEntity(world, (LivingEntity)player, 32.0f);
            BlockPos hitPos = new BlockPos(raytrace.func_216347_e());
            if (raytrace.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_175660_a(player, hitPos) && player.func_175151_a(hitPos, null, item)) {
                if (player.func_225608_bj_()) {
                    ConchItem.attemptTakeWater(player, world, hitPos);
                } else {
                    ConchItem.attemptPlaceWater(player, world, hitPos, player.func_174811_aO().func_176734_d());
                }
                player.func_184811_cZ().func_185145_a((Item)this, GreekFantasy.CONFIG.getConchCooldown());
                return ActionResult.func_226248_a_((Object)item);
            }
        }
        return ActionResult.func_226250_c_((Object)item);
    }

    public static boolean attemptTakeWater(PlayerEntity player, World worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        FluidState fluidstate = worldIn.func_204610_c(pos);
        Block block = blockstate.func_177230_c();
        if (block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)worldIn, pos, blockstate, Fluids.field_204541_a)) {
            ((ILiquidContainer)block).func_204509_a((IWorld)worldIn, pos, blockstate, Fluids.field_204541_a.func_207188_f());
            worldIn.func_184133_a(player, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (!worldIn.func_201670_d() && fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
            worldIn.func_175655_b(pos, true);
        }
        if (blockstate.func_204520_s().func_206889_d() && !worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11)) {
            return false;
        }
        worldIn.func_184133_a(player, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public static boolean attemptPlaceWater(PlayerEntity player, World worldIn, BlockPos pos, @Nullable Direction facing) {
        boolean canReceiveWater;
        BlockState selected = worldIn.func_180495_p(pos);
        Block block = selected.func_177230_c();
        boolean replaceable = selected.func_227032_a_((Fluid)Fluids.field_204546_a);
        boolean bl = canReceiveWater = worldIn.func_175623_d(pos) || replaceable || block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)worldIn, pos, selected, (Fluid)Fluids.field_204546_a);
        if (!canReceiveWater && facing != null) {
            return ConchItem.attemptPlaceWater(player, worldIn, pos.func_177972_a(facing), null);
        }
        if (worldIn.func_230315_m_().func_236040_e_()) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            worldIn.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return false;
        }
        if (block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)worldIn, pos, selected, (Fluid)Fluids.field_204546_a)) {
            ((ILiquidContainer)block).func_204509_a((IWorld)worldIn, pos, selected, Fluids.field_204546_a.func_207204_a(false));
            worldIn.func_184133_a(player, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (!worldIn.func_201670_d() && replaceable && !selected.func_185904_a().func_76224_d()) {
            worldIn.func_175655_b(pos, true);
        }
        if (!worldIn.func_180501_a(pos, Fluids.field_204546_a.func_207188_f().func_206883_i(), 11) && !selected.func_204520_s().func_206889_d()) {
            return false;
        }
        worldIn.func_184133_a(player, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }
}

