/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.gui.GuiLoader;
import greekfantasy.util.SongManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public abstract class InstrumentItem
extends Item {
    public static final ResourceLocation DEFAULT_SONG = new ResourceLocation("greekfantasy", "greensleeves");
    public static final String KEY_SONG = "Song";
    public static final String TOOLTIP = "item.tooltip.right_click_instrument";

    public InstrumentItem(Item.Properties properties) {
        super(properties);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            InstrumentItem.writeSong(stack, DEFAULT_SONG);
            items.add((Object)stack);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        SongManager.playMusic(player, this, InstrumentItem.readSong(stack), this.func_77626_a(stack) - count, this.getTrebleVolume(), this.getBassVolume());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (worldIn.func_201670_d()) {
                GuiLoader.openSongGui(playerIn, playerIn.field_71071_by.field_70461_c, itemstack);
            }
        } else {
            playerIn.func_184598_c(handIn);
        }
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int timeUsed = this.func_77626_a(stack) - timeLeft;
        if (timeUsed < 10 && stack.func_77973_b() == this && worldIn.func_201670_d() && entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            GuiLoader.openSongGui(player, player.field_71071_by.field_70461_c, stack);
        }
    }

    public static void writeSong(ItemStack stack, ResourceLocation song) {
        stack.func_196082_o().func_74778_a(KEY_SONG, song.toString());
    }

    public static ResourceLocation readSong(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b(KEY_SONG)) {
            return new ResourceLocation(stack.func_77978_p().func_74779_i(KEY_SONG));
        }
        return DEFAULT_SONG;
    }

    public float getPitch(int note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    public float getTrebleVolume() {
        return 1.0f;
    }

    public float getBassVolume() {
        return 0.45f;
    }

    public abstract SoundEvent getSound();
}

