/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.util.math.MathHelper;

public class IvorySwordItem
extends SwordItem {
    public static final UUID ATTACK_KNOCKBACK_MODIFIER = UUID.fromString("dd208092-978f-4e55-b9b8-7e65c7c760e6");
    public static final double ATTACK_KNOCKBACK_AMOUNT = 1.25;
    protected final Multimap<Attribute, AttributeModifier> attributeModifierMap;

    public IvorySwordItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(tier, attackDamageIn, attackSpeedIn, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)((float)attackDamageIn + tier.func_200929_c()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233824_g_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", 1.25, AttributeModifier.Operation.ADDITION));
        this.attributeModifierMap = builder.build();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.func_77644_a(stack, target, attacker);
        if (attacker instanceof PlayerEntity && !((PlayerEntity)attacker).func_184811_cZ().func_185141_a((Item)this)) {
            float knockback = 0.0f;
            for (AttributeModifier modifier : this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack).get((Object)Attributes.field_233824_g_)) {
                knockback = (float)((double)knockback + modifier.func_111164_d());
            }
            target.func_233627_a_(knockback * 0.75f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifierMap : super.getAttributeModifiers(equipmentSlot, stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151103_aS;
    }

    public int func_77619_b() {
        return ItemTier.STONE.func_200927_e();
    }
}

