/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import greekfantasy.entity.misc.SpearEntity;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class SpearItem
extends TieredItem
implements IVanishable {
    public static final String KEY_POTION = "Potion";
    protected final Multimap<Attribute, AttributeModifier> spearAttributes;
    public final Consumer<Entity> onHitEntity;

    public SpearItem(IItemTier tier, Item.Properties properties) {
        this(tier, properties, e -> {});
    }

    public SpearItem(IItemTier tier, Item.Properties properties, Consumer<Entity> hitEntityConsumer) {
        super(tier, properties);
        this.onHitEntity = hitEntityConsumer;
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        mapBuilder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", 5.0 + (double)tier.func_200929_c(), AttributeModifier.Operation.ADDITION));
        mapBuilder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.9, AttributeModifier.Operation.ADDITION));
        this.spearAttributes = mapBuilder.build();
    }

    public boolean func_195938_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_190925_c(KEY_POTION).func_74764_b(KEY_POTION);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int duration) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        int useDuration = this.func_77626_a(stack) - duration;
        if (useDuration < 10) {
            return;
        }
        if (!world.func_201670_d()) {
            this.throwSpear(world, player, stack);
        }
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
    }

    protected void throwSpear(World world, PlayerEntity thrower, ItemStack stack) {
        stack.func_222118_a(1, (LivingEntity)thrower, e -> e.func_213334_d(thrower.func_184600_cs()));
        SpearEntity spear = new SpearEntity(world, (LivingEntity)thrower, stack, this.onHitEntity);
        spear.func_234612_a_((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 2.25f, 1.0f);
        if (thrower.field_71075_bZ.field_75098_d) {
            spear.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        } else {
            thrower.field_71071_by.func_184437_d(stack);
        }
        world.func_217376_c((Entity)spear);
        world.func_217384_a(null, (Entity)spear, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity user) {
        stack.func_222118_a(1, user, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        CompoundNBT nbt = stack.func_190925_c(KEY_POTION).func_74737_b();
        if (nbt.func_74764_b(KEY_POTION)) {
            nbt.func_74774_a("Id", (byte)Effect.func_188409_a((Effect)((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(nbt.func_74779_i(KEY_POTION))))));
            target.func_195064_c(EffectInstance.func_82722_b((CompoundNBT)nbt));
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if ((double)state.func_185887_b((IBlockReader)world, pos) != 0.0) {
            stack.func_222118_a(2, entity, p_220046_0_ -> p_220046_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.MAINHAND ? this.spearAttributes : super.func_111205_h(slot);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.field_203193_C;
    }

    public int func_77619_b() {
        return Math.max(1, super.func_77619_b() / 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_190925_c(KEY_POTION);
        if (nbt.func_74764_b(KEY_POTION)) {
            Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(nbt.func_74779_i(KEY_POTION)));
            int level = 1 + nbt.func_74762_e("Amplifier");
            tooltip.add((ITextComponent)new TranslationTextComponent(potion.func_76393_a()).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + level)).func_240699_a_(TextFormatting.GREEN));
        }
    }
}

