/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ThunderboltItem
extends Item {
    public ThunderboltItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        RayTraceResult raytrace;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77958_k() - stack.func_77952_i() <= 1) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (GreekFantasy.CONFIG.isThunderboltStormsOnly() && !world.func_72896_J() && !world.func_72911_I()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.thunderbolt_only_when_raining"), true);
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!world.func_201670_d() && (raytrace = ThunderboltItem.raytraceFromEntity(world, (LivingEntity)player, 64.0f)).func_216346_c() != RayTraceResult.Type.MISS) {
            boolean fireflash;
            LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            bolt.func_70107_b(raytrace.func_216347_e().func_82615_a(), raytrace.func_216347_e().func_82617_b(), raytrace.func_216347_e().func_82616_c());
            world.func_217376_c((Entity)bolt);
            int damageAmount = 15;
            int fireflashLevel = EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.FIREFLASH_ENCHANTMENT, (ItemStack)stack);
            boolean bl = fireflash = GreekFantasy.CONFIG.isFireflashEnabled() && fireflashLevel > 0 && GreekFantasy.PROXY.getFavorConfiguration().getEnchantmentRange("fireflash_enchantment").isInFavorRange(player);
            if (fireflash) {
                damageAmount = 25;
                Explosion.Mode mode = GreekFantasy.CONFIG.doesFireflashDestroyBlocks() ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                world.func_217398_a((Entity)player, raytrace.func_216347_e().func_82615_a(), raytrace.func_216347_e().func_82617_b(), raytrace.func_216347_e().func_82616_c(), (float)fireflashLevel * 1.64f, true, mode);
            }
            player.func_184811_cZ().func_185145_a((Item)this, GreekFantasy.CONFIG.getThunderboltCooldown() / (fireflash ? 2 : 1));
            if (!player.func_184812_l_()) {
                stack.func_222118_a(damageAmount, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
        return ActionResult.func_233538_a_((Object)stack, (boolean)world.func_201670_d());
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return toRepair.func_77973_b() == this && toRepair.func_77952_i() < toRepair.func_77958_k() && this.isRepairItem(repair);
    }

    private boolean isRepairItem(ItemStack repair) {
        return repair.func_77973_b() == GFRegistry.ICHOR;
    }

    public static RayTraceResult raytraceFromEntity(World world, LivingEntity player, float range) {
        Vector3d startVec = player.func_174824_e(1.0f);
        float pitch = (float)Math.toRadians(-player.field_70125_A);
        float yaw = (float)Math.toRadians(-player.field_70177_z);
        float cosYaw = MathHelper.func_76134_b((float)(yaw - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(yaw - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)pitch);
        float sinPitch = MathHelper.func_76126_a((float)pitch);
        Vector3d endVec = startVec.func_72441_c((double)(sinYaw * cosPitch * range), (double)(sinPitch * range), (double)(cosYaw * cosPitch * range));
        return player.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
    }
}

