/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.client.render.model.armor.WingedSandalsModel;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WingedSandalsItem
extends ArmorItem {
    public static final UUID SPEED_MODIFIER = UUID.fromString("58b7ff54-706b-4b0b-80f7-0dce04a673e4");
    protected static final IArmorMaterial MATERIAL = new WingedSandalsArmorMaterial();
    private static final String TEXTURE = "greekfantasy:textures/models/armor/winged_layer_2.png";
    @OnlyIn(value=Dist.CLIENT)
    private WingedSandalsModel MODEL;
    protected final Multimap<Attribute, AttributeModifier> flyingAttributeModifiers;
    protected final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public WingedSandalsItem(Item.Properties builderIn) {
        super(MATERIAL, EquipmentSlotType.FEET, builderIn);
        double speedBonus = (Double)GreekFantasy.CONFIG.SANDALS_SPEED_BONUS.get();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.func_111205_h(EquipmentSlotType.FEET));
        this.flyingAttributeModifiers = builder.build();
        builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(SPEED_MODIFIER, "Armor speed modifier", speedBonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.attributeModifiers = builder.build();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            if (GreekFantasy.CONFIG.isOverstepEnabled()) {
                stack.func_77966_a(GFRegistry.OVERSTEP_ENCHANTMENT, 1);
            }
            items.add((Object)stack);
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        if (GreekFantasy.CONFIG.isOverstepEnabled() && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.OVERSTEP_ENCHANTMENT, (ItemStack)stack) < 1) {
            stack.func_77966_a(GFRegistry.OVERSTEP_ENCHANTMENT, 1);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return GreekFantasy.CONFIG.isOverstepEnabled() ? stack.func_77986_q().size() > 1 : super.func_77636_d(stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (GreekFantasy.CONFIG.isOverstepEnabled() && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.OVERSTEP_ENCHANTMENT, (ItemStack)stack) < 1) {
            stack.func_77966_a(GFRegistry.OVERSTEP_ENCHANTMENT, 1);
        }
        if (itemSlot == EquipmentSlotType.FEET.func_188454_b() && stack.func_77958_k() - stack.func_77952_i() > 10 && entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            entity.func_195064_c(new EffectInstance(Effects.field_76430_j, 20, 4, false, false, false));
            entity.field_70143_R = 0.0f;
            if (GreekFantasy.CONFIG.doesWingedSandalsDeplete() && entity.func_70681_au().nextInt(40) == 0 && (!(entity instanceof PlayerEntity) || !entity.func_175149_v() && !((PlayerEntity)entity).func_184812_l_())) {
                stack.func_222118_a(1, entity, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        if (equipmentSlot == EquipmentSlotType.FEET && stack.func_77958_k() - stack.func_77952_i() > 10) {
            return this.attributeModifiers;
        }
        return super.getAttributeModifiers(equipmentSlot, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77958_k() - stack.func_77952_i() <= 10) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.tooltip.broken").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("effect.minecraft.jump_boost").func_240699_a_(TextFormatting.AQUA).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level.5").func_240699_a_(TextFormatting.AQUA)));
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (this.MODEL == null) {
            this.MODEL = new WingedSandalsModel(1.0f);
        }
        this.MODEL.field_217114_e = _default.field_217114_e;
        this.MODEL.field_228270_o_ = _default.field_228270_o_;
        this.MODEL.field_217113_d = _default.field_217113_d;
        this.MODEL.func_225597_a_(entityLiving, entityLiving.field_184619_aG, entityLiving.field_70721_aZ, (float)entityLiving.field_70173_aa, entityLiving.field_70759_as, entityLiving.field_70125_A);
        return (A)((Object)this.MODEL);
    }

    public static class WingedSandalsArmorMaterial
    implements IArmorMaterial {
        private static final String NAME = "winged";

        public int func_200902_b(EquipmentSlotType arg0) {
            return 2;
        }

        public int func_200896_a(EquipmentSlotType arg0) {
            return 195;
        }

        public int func_200900_a() {
            return 15;
        }

        public float func_230304_f_() {
            return 0.0f;
        }

        public String func_200897_d() {
            return NAME;
        }

        public Ingredient func_200898_c() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{GFRegistry.MAGIC_FEATHER});
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187728_s;
        }

        public float func_200901_e() {
            return 0.0f;
        }
    }
}

