/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.loot;

import com.google.gson.JsonObject;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.favor.FavorConfiguration;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.deity.favor_effect.ConfiguredSpecialFavorEffect;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class AutosmeltOrCobbleModifier
extends LootModifier {
    private final Block stone;
    private final ResourceLocation oresTag;
    private final ITag<Block> ores;

    protected AutosmeltOrCobbleModifier(ILootCondition[] conditionsIn, Block stoneIn, ResourceLocation oresTagIn) {
        super(conditionsIn);
        this.stone = stoneIn;
        this.oresTag = oresTagIn;
        this.ores = BlockTags.createOptional((ResourceLocation)oresTagIn);
    }

    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = context.func_216033_a(LootParameters.field_216281_a) ? (Entity)context.func_216031_c(LootParameters.field_216281_a) : null;
        FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
        boolean canAutosmelt = true;
        boolean canCancel = true;
        if (entity instanceof PlayerEntity && context.func_216033_a(LootParameters.field_216287_g) && ((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().func_203417_a(this.ores) && !entity.func_175149_v() && !((PlayerEntity)entity).func_184812_l_()) {
            PlayerEntity player = (PlayerEntity)entity;
            long time = IFavor.calculateTime((Entity)player);
            LazyOptional lFavor = entity.getCapability(GreekFantasy.FAVOR);
            IFavor favor = (IFavor)lFavor.orElse(GreekFantasy.FAVOR.getDefaultInstance());
            if (lFavor.isPresent() && favor.hasNoTriggeredCooldown(time)) {
                ArrayList<ItemStack> replacement = new ArrayList<ItemStack>();
                for (ConfiguredSpecialFavorEffect autosmelt : favorConfig.getSpecials(SpecialFavorEffect.Type.MINING_AUTOSMELT)) {
                    if (!autosmelt.canApply(player, favor)) continue;
                    generatedLoot.forEach(stack -> replacement.add(AutosmeltOrCobbleModifier.smelt(stack, context)));
                    favor.setTriggeredTime(time, autosmelt.getEffect().getRandomCooldown(player.func_70681_au()));
                    return replacement;
                }
                for (ConfiguredSpecialFavorEffect unsmelt : favorConfig.getSpecials(SpecialFavorEffect.Type.MINING_CANCEL_ORES)) {
                    if (!unsmelt.canApply(player, favor)) continue;
                    replacement.add(new ItemStack((IItemProvider)this.stone));
                    favor.setTriggeredTime(time, unsmelt.getEffect().getRandomCooldown(player.func_70681_au()));
                    return replacement;
                }
            }
        }
        return generatedLoot;
    }

    private static ItemStack smelt(ItemStack stack, LootContext context) {
        return context.func_202879_g().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)context.func_202879_g()).map(AbstractCookingRecipe::func_77571_b).filter(itemStack -> !itemStack.func_190926_b()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.func_190916_E() * itemStack.func_190916_E()))).orElse(stack);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AutosmeltOrCobbleModifier> {
        private static final String STONE = "stone";
        private static final String ORES = "ores";

        public AutosmeltOrCobbleModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            Block stone = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)STONE)));
            ResourceLocation oresTag = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)ORES));
            return new AutosmeltOrCobbleModifier(conditionsIn, stone, oresTag);
        }

        public JsonObject write(AutosmeltOrCobbleModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty(STONE, instance.stone.getRegistryName().toString());
            json.addProperty(ORES, instance.oresTag.toString());
            return json;
        }
    }
}

