/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.loot;

import com.google.gson.JsonObject;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.favor.FavorConfiguration;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.deity.favor_effect.ConfiguredSpecialFavorEffect;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.util.LazyOptional;

public class CropMultiplierModifier
extends LootModifier {
    private final ResourceLocation cropsTag;
    private final ITag<Block> crops;

    protected CropMultiplierModifier(ILootCondition[] conditionsIn, ResourceLocation cropsTagIn) {
        super(conditionsIn);
        this.cropsTag = cropsTagIn;
        this.crops = BlockTags.func_199894_a((String)cropsTagIn.toString());
    }

    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = context.func_216033_a(LootParameters.field_216281_a) ? (Entity)context.func_216031_c(LootParameters.field_216281_a) : null;
        FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
        if (entity instanceof PlayerEntity && context.func_216033_a(LootParameters.field_216287_g) && ((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().func_203417_a(this.crops) && !entity.func_175149_v() && !((PlayerEntity)entity).func_184812_l_()) {
            PlayerEntity player = (PlayerEntity)entity;
            long time = IFavor.calculateTime((Entity)player);
            LazyOptional lFavor = entity.getCapability(GreekFantasy.FAVOR);
            IFavor favor = (IFavor)lFavor.orElse(GreekFantasy.FAVOR.getDefaultInstance());
            if (lFavor.isPresent() && favor.hasNoTriggeredCooldown(time)) {
                long cooldown = -1L;
                for (ConfiguredSpecialFavorEffect cropsMultiplier : favorConfig.getSpecials(SpecialFavorEffect.Type.CROP_HARVEST_MULTIPLIER)) {
                    if (!cropsMultiplier.canApply(player, favor)) continue;
                    generatedLoot.forEach(i -> i.func_190917_f(Math.round((float)i.func_190916_E() * cropsMultiplier.getEffect().getMultiplier().orElse(Float.valueOf(0.0f)).floatValue())));
                    cooldown = Math.max(cooldown, cropsMultiplier.getEffect().getRandomCooldown(player.func_70681_au()));
                }
                if (cooldown > 0L) {
                    favor.setTriggeredTime(time, cooldown);
                }
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<CropMultiplierModifier> {
        private static final String CROPS = "crops";

        public CropMultiplierModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            ResourceLocation cropsTag = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)CROPS));
            return new CropMultiplierModifier(conditionsIn, cropsTag);
        }

        public JsonObject write(CropMultiplierModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty(CROPS, instance.cropsTag.toString());
            return json;
        }
    }
}

