/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import greekfantasy.item.InstrumentItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class CUpdateInstrumentPacket {
    protected int slot;
    protected ResourceLocation songName;

    public CUpdateInstrumentPacket() {
    }

    public CUpdateInstrumentPacket(int slotIn, ResourceLocation songNameIn) {
        this.slot = slotIn;
        this.songName = songNameIn;
    }

    public int getSlot() {
        return this.slot;
    }

    public static CUpdateInstrumentPacket fromBytes(PacketBuffer buf) {
        int msgSlot = buf.readInt();
        ResourceLocation msgSongName = buf.func_192575_l();
        return new CUpdateInstrumentPacket(msgSlot, msgSongName);
    }

    public static void toBytes(CUpdateInstrumentPacket msg, PacketBuffer buf) {
        buf.writeInt(msg.getSlot());
        buf.func_192572_a(msg.songName);
    }

    public static void handlePacket(CUpdateInstrumentPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ItemStack stack;
                ServerPlayerEntity player = context.getSender();
                if (message.getSlot() >= 0 && message.getSlot() < player.field_71071_by.func_70302_i_() && (stack = player.field_71071_by.func_70301_a(message.getSlot())).func_77973_b() instanceof InstrumentItem) {
                    InstrumentItem.writeSong(stack, message.songName);
                    player.field_71071_by.func_70299_a(message.getSlot(), stack);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

