/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import greekfantasy.tileentity.StatueTileEntity;
import greekfantasy.util.StatuePose;
import greekfantasy.util.StatuePoses;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class CUpdateStatuePosePacket {
    protected static final int NAME_LEN = 16;
    protected BlockPos blockPos = BlockPos.field_177992_a;
    protected StatuePose statuePose = StatuePoses.NONE;
    protected boolean statueFemale = false;
    protected String textureName = "";

    public CUpdateStatuePosePacket() {
    }

    public CUpdateStatuePosePacket(BlockPos blockPosIn, StatuePose statuePoseIn, boolean statueFemaleIn, String textureNameIn) {
        this.blockPos = blockPosIn;
        this.statuePose = statuePoseIn;
        this.statueFemale = statueFemaleIn;
        this.textureName = textureNameIn;
    }

    public static CUpdateStatuePosePacket fromBytes(PacketBuffer buf) {
        BlockPos blockPos = buf.func_179259_c();
        CompoundNBT nbt = buf.func_150793_b();
        boolean female = buf.readBoolean();
        String textureName = buf.func_150789_c(16);
        return new CUpdateStatuePosePacket(blockPos, new StatuePose(nbt), female, textureName);
    }

    public static void toBytes(CUpdateStatuePosePacket msg, PacketBuffer buf) {
        buf.func_179255_a(msg.blockPos);
        buf.func_150786_a(msg.statuePose.serializeNBT());
        buf.writeBoolean(msg.statueFemale);
        String name = msg.textureName;
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        buf.func_211400_a(name, 16);
    }

    public static void handlePacket(CUpdateStatuePosePacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                TileEntity tileentity;
                ServerPlayerEntity player = context.getSender();
                if (message.blockPos.func_177951_i((Vector3i)player.func_233580_cy_()) < 100.0 && (tileentity = context.getSender().func_130014_f_().func_175625_s(message.blockPos)) instanceof StatueTileEntity) {
                    StatueTileEntity statueTileEntity = (StatueTileEntity)tileentity;
                    statueTileEntity.setStatuePose(message.statuePose);
                    statueTileEntity.setStatueFemale(message.statueFemale, true);
                    statueTileEntity.setTextureName(message.textureName, true);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

