/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.WhirlEntity;
import greekfantasy.item.ThunderboltItem;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class CUseEnchantmentPacket {
    protected ResourceLocation enchantment;

    public CUseEnchantmentPacket() {
    }

    public CUseEnchantmentPacket(ResourceLocation enchantmentIn) {
        this.enchantment = enchantmentIn;
    }

    public static CUseEnchantmentPacket fromBytes(PacketBuffer buf) {
        return new CUseEnchantmentPacket(buf.func_192575_l());
    }

    public static void toBytes(CUseEnchantmentPacket msg, PacketBuffer buf) {
        buf.func_192572_a(msg.enchantment);
    }

    public static void handlePacket(CUseEnchantmentPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayerEntity player = context.getSender();
                ItemStack item = player.func_184614_ca();
                if (GFRegistry.LORD_OF_THE_SEA_ENCHANTMENT.getRegistryName().equals((Object)message.enchantment) && GreekFantasy.CONFIG.isLordOfTheSeaEnabled() && item.func_77973_b() == Items.field_203184_eO && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.LORD_OF_THE_SEA_ENCHANTMENT, (ItemStack)item) > 0 && !player.func_184811_cZ().func_185141_a(Items.field_203184_eO) && GreekFantasy.PROXY.getFavorConfiguration().getEnchantmentRange("lord_of_the_sea_enchantment").isInFavorRange((PlayerEntity)player)) {
                    CUseEnchantmentPacket.useLordOfTheSea(player, item);
                }
                if (GFRegistry.DAYBREAK_ENCHANTMENT.getRegistryName().equals((Object)message.enchantment) && GreekFantasy.CONFIG.isDaybreakEnabled() && item.func_77973_b() == Items.field_151113_aN && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.DAYBREAK_ENCHANTMENT, (ItemStack)item) > 0 && player.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223607_j) && player.func_130014_f_().func_72820_D() % 24000L > 13000L && GreekFantasy.PROXY.getFavorConfiguration().getEnchantmentRange("daybreak_enchantment").isInFavorRange((PlayerEntity)player)) {
                    CUseEnchantmentPacket.useDaybreak(player, item);
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static void useLordOfTheSea(ServerPlayerEntity player, ItemStack item) {
        RayTraceResult raytrace = ThunderboltItem.raytraceFromEntity(player.func_130014_f_(), (LivingEntity)player, 48.0f);
        if (raytrace.func_216346_c() != RayTraceResult.Type.MISS) {
            WhirlEntity whirl = (WhirlEntity)GFRegistry.WHIRL_ENTITY.func_200721_a(player.func_130014_f_());
            BlockPos pos = new BlockPos(raytrace.func_216347_e());
            if (player.func_130014_f_().func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) && player.func_130014_f_().func_204610_c(pos.func_177979_c((int)Math.ceil(whirl.func_213302_cg()))).func_206884_a((ITag)FluidTags.field_206959_a)) {
                whirl.func_70012_b(raytrace.func_216347_e().func_82615_a(), raytrace.func_216347_e().func_82617_b() - (double)whirl.func_213302_cg(), raytrace.func_216347_e().func_82616_c(), 0.0f, 0.0f);
                player.func_130014_f_().func_217376_c((Entity)whirl);
                whirl.setLimitedLife(GreekFantasy.CONFIG.getWhirlLifespan() * 20);
                whirl.setAttractMobs(true);
                whirl.func_184185_a(SoundEvents.field_203275_iq, 1.5f, 0.6f + whirl.func_70681_au().nextFloat() * 0.32f);
                LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(player.func_130014_f_());
                bolt.func_174810_b(true);
                bolt.func_70107_b(raytrace.func_216347_e().func_82615_a(), raytrace.func_216347_e().func_82617_b(), raytrace.func_216347_e().func_82616_c());
                player.func_130014_f_().func_217376_c((Entity)bolt);
                player.func_184811_cZ().func_185145_a(item.func_77973_b(), GreekFantasy.CONFIG.getWhirlLifespan() * 10);
                if (!player.func_184812_l_()) {
                    item.func_222118_a(25, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                }
            }
        }
    }

    private static void useDaybreak(ServerPlayerEntity player, ItemStack item) {
        ServerWorld world = player.func_71121_q();
        long nextDay = world.func_72912_H().func_76073_f() + 24000L;
        world.func_241114_a_(nextDay - nextDay % 24000L);
        player.func_213361_c(EquipmentSlotType.MAINHAND);
        if (!player.func_184812_l_()) {
            item.func_190918_g(1);
        }
    }
}

