/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import com.mojang.serialization.DataResult;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SDeityPacket {
    protected ResourceLocation deityName;
    protected Deity deity;

    public SDeityPacket(ResourceLocation deityNameIn, Deity deityIn) {
        this.deityName = deityNameIn;
        this.deity = deityIn;
    }

    public static SDeityPacket fromBytes(PacketBuffer buf) {
        ResourceLocation sName = buf.func_192575_l();
        CompoundNBT sNBT = buf.func_150793_b();
        Optional sEffect = GreekFantasy.PROXY.DEITY.readObject((INBT)sNBT).resultOrPartial(error -> GreekFantasy.LOGGER.error("Failed to read IDeity from NBT for packet\n" + error));
        return new SDeityPacket(sName, sEffect.orElse(Deity.EMPTY));
    }

    public static void toBytes(SDeityPacket msg, PacketBuffer buf) {
        DataResult<INBT> nbtResult = GreekFantasy.PROXY.DEITY.writeObject(msg.deity);
        INBT tag = (INBT)nbtResult.resultOrPartial(error -> GreekFantasy.LOGGER.error("Failed to write IDeity to NBT for packet\n" + error)).get();
        buf.func_192572_a(msg.deityName);
        buf.func_150786_a((CompoundNBT)tag);
    }

    public static void handlePacket(SDeityPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> GreekFantasy.PROXY.DEITY.put(message.deityName, message.deity));
        }
        context.setPacketHandled(true);
    }
}

