/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import com.mojang.serialization.DataResult;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.favor.FavorConfiguration;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SFavorConfigurationPacket {
    protected FavorConfiguration favorConfig;

    public SFavorConfigurationPacket(FavorConfiguration favorRangeIn) {
        this.favorConfig = favorRangeIn;
    }

    public static SFavorConfigurationPacket fromBytes(PacketBuffer buf) {
        CompoundNBT sNBT = buf.func_150793_b();
        Optional sEffect = GreekFantasy.PROXY.FAVOR_CONFIGURATION.readObject((INBT)sNBT).resultOrPartial(error -> GreekFantasy.LOGGER.error("Failed to read FavorConfiguration from NBT for packet\n" + error));
        return new SFavorConfigurationPacket(sEffect.orElse(FavorConfiguration.EMPTY));
    }

    public static void toBytes(SFavorConfigurationPacket msg, PacketBuffer buf) {
        DataResult<INBT> nbtResult = GreekFantasy.PROXY.FAVOR_CONFIGURATION.writeObject(msg.favorConfig);
        INBT tag = (INBT)nbtResult.resultOrPartial(error -> GreekFantasy.LOGGER.error("Failed to write FavorConfiguration to NBT for packet\n" + error)).get();
        buf.func_150786_a((CompoundNBT)tag);
    }

    public static void handlePacket(SFavorConfigurationPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> GreekFantasy.PROXY.FAVOR_CONFIGURATION.put(FavorConfiguration.NAME, message.favorConfig));
        }
        context.setPacketHandled(true);
    }
}

