/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import com.mojang.serialization.DataResult;
import greekfantasy.GreekFantasy;
import greekfantasy.util.Song;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPanfluteSongPacket {
    protected ResourceLocation songName;
    protected Song song;

    public SPanfluteSongPacket() {
    }

    public SPanfluteSongPacket(ResourceLocation songNameIn, Song songIn) {
        this.songName = songNameIn;
        this.song = songIn;
    }

    public static SPanfluteSongPacket fromBytes(PacketBuffer buf) {
        ResourceLocation sName = buf.func_192575_l();
        CompoundNBT sNBT = buf.func_150793_b();
        Optional sSong = GreekFantasy.PROXY.PANFLUTE_SONGS.readObject((INBT)sNBT).resultOrPartial(error -> GreekFantasy.LOGGER.error("Failed to read deity from NBT for packet\n" + error));
        return new SPanfluteSongPacket(sName, sSong.orElse(Song.EMPTY));
    }

    public static void toBytes(SPanfluteSongPacket msg, PacketBuffer buf) {
        DataResult<INBT> nbtResult = GreekFantasy.PROXY.PANFLUTE_SONGS.writeObject(msg.song);
        INBT tag = (INBT)nbtResult.resultOrPartial(error -> GreekFantasy.LOGGER.error("Failed to write deity to NBT for packet\n" + error)).get();
        buf.func_192572_a(msg.songName);
        buf.func_150786_a((CompoundNBT)tag);
    }

    public static void handlePacket(SPanfluteSongPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> GreekFantasy.PROXY.PANFLUTE_SONGS.put(message.songName, message.song));
        }
        context.setPacketHandled(true);
    }
}

