/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSimpleParticlesPacket {
    protected boolean isHappy;
    protected BlockPos pos = BlockPos.field_177992_a;
    protected byte count = 0;

    public SSimpleParticlesPacket() {
    }

    public SSimpleParticlesPacket(boolean isHappyIn, BlockPos posIn, int countIn) {
        this.isHappy = isHappyIn;
        this.pos = posIn;
        this.count = (byte)Math.max(countIn, 127);
    }

    public static SSimpleParticlesPacket fromBytes(PacketBuffer buf) {
        boolean happy = buf.readBoolean();
        BlockPos pos = buf.func_179259_c();
        byte count = buf.readByte();
        return new SSimpleParticlesPacket(happy, pos, count);
    }

    public static void toBytes(SSimpleParticlesPacket msg, PacketBuffer buf) {
        buf.writeBoolean(msg.isHappy);
        buf.func_179255_a(msg.pos);
        buf.writeByte((int)msg.count);
    }

    public static void handlePacket(SSimpleParticlesPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                BasicParticleType particle = message.isHappy ? ParticleTypes.field_197632_y : ParticleTypes.field_197609_b;
                Random rand = mc.field_71439_g.func_70681_au();
                for (int i = 0; i < message.count; ++i) {
                    double x2 = (double)message.pos.func_177958_n() + rand.nextDouble();
                    double y2 = (double)message.pos.func_177956_o() + rand.nextDouble();
                    double z2 = (double)message.pos.func_177952_p() + rand.nextDouble();
                    mc.field_71441_e.func_195594_a((IParticleData)particle, x2, y2, z2, 0.0, 0.0, 0.0);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

