/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import greekfantasy.GFRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSwineEffectPacket {
    protected int entity;
    protected int duration;

    public SSwineEffectPacket() {
    }

    public SSwineEffectPacket(int entityIn, int durationIn) {
        this.entity = entityIn;
        this.duration = durationIn;
    }

    public static SSwineEffectPacket fromBytes(PacketBuffer buf) {
        int uuid = buf.readInt();
        int duration = buf.readInt();
        return new SSwineEffectPacket(uuid, duration);
    }

    public static void toBytes(SSwineEffectPacket msg, PacketBuffer buf) {
        buf.writeInt(msg.entity);
        buf.writeInt(msg.duration);
    }

    public static void handlePacket(SSwineEffectPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                Entity e = mc.field_71441_e.func_73045_a(message.entity);
                if (e instanceof LivingEntity) {
                    ((LivingEntity)e).func_195064_c(new EffectInstance(GFRegistry.SWINE_EFFECT, message.duration));
                }
            });
        }
        context.setPacketHandled(true);
    }
}

