/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.tileentity;

import greekfantasy.GFRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class MobHeadTileEntity
extends TileEntity {
    private static final String KEY_HEAD = "HeadType";
    private static final String KEY_WALL = "Wall";
    private HeadType headType = HeadType.GIGANTE;
    private boolean wall = false;

    public MobHeadTileEntity() {
        super(GFRegistry.BOSS_HEAD_TE);
    }

    public HeadType getHeadType() {
        return this.headType;
    }

    public void setHeadType(HeadType headTypeIn) {
        if (this.headType != headTypeIn) {
            this.headType = headTypeIn;
            this.func_70296_d();
        }
    }

    public boolean onWall() {
        return this.wall;
    }

    public void setWall(boolean isOnWall) {
        if (this.wall != isOnWall) {
            this.wall = isOnWall;
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74774_a(KEY_HEAD, this.headType.getId());
        nbt.func_74757_a(KEY_WALL, this.wall);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.read(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.read(pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.read(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a(KEY_HEAD, this.headType.getId());
        nbt.func_74757_a(KEY_WALL, this.wall);
        return nbt;
    }

    protected void read(CompoundNBT nbt) {
        this.setHeadType(HeadType.getById(nbt.func_74771_c(KEY_HEAD)));
        this.setWall(nbt.func_74767_n(KEY_WALL));
    }

    public static enum HeadType {
        GIGANTE(0, new ResourceLocation("greekfantasy", "textures/entity/gigante.png")),
        ORTHUS(1, new ResourceLocation("greekfantasy", "textures/entity/orthus/orthus.png")),
        CERBERUS(2, new ResourceLocation("greekfantasy", "textures/entity/cerberus/cerberus.png"));

        private final byte id;
        public final ResourceLocation texture;

        private HeadType(byte typeID, ResourceLocation headTexture) {
            this.id = typeID;
            this.texture = headTexture;
        }

        public byte getId() {
            return this.id;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public static HeadType getById(byte b) {
            for (HeadType h : HeadType.values()) {
                if (h.getId() != b) continue;
                return h;
            }
            return GIGANTE;
        }
    }
}

