/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.tileentity;

import com.mojang.authlib.GameProfile;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.block.StatueBlock;
import greekfantasy.deity.Deity;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorConfiguration;
import greekfantasy.deity.favor.FavorRange;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.event.FavorChangedEvent;
import greekfantasy.util.ModelPart;
import greekfantasy.util.StatuePose;
import greekfantasy.util.StatuePoses;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StatueTileEntity
extends TileEntity
implements IClearable,
IInventory {
    private static final String KEY_POSE = "Pose";
    private static final String KEY_UPPER = "Upper";
    private static final String KEY_FEMALE = "Female";
    private static final String KEY_NAME = "Name";
    private static final String KEY_DEITY = "Deity";
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private StatuePose statuePose = StatuePoses.NONE;
    private boolean upper = false;
    private boolean statueFemale = false;
    private String textureName = "";
    private String deityName = "";
    @Nullable
    private GameProfile playerProfile = null;
    @Nullable
    private IDeity deity = Deity.EMPTY;

    public StatueTileEntity() {
        this(GFRegistry.STATUE_TE);
    }

    public StatueTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void setUpper(boolean isUpper) {
        this.upper = isUpper;
        this.func_70296_d();
    }

    public boolean isUpper() {
        return this.upper;
    }

    public StatuePose getStatuePose() {
        return this.statuePose;
    }

    public void setStatuePose(StatuePose poseIn) {
        this.setStatuePose(poseIn, false);
    }

    public void setStatuePose(StatuePose poseIn, boolean refresh) {
        this.statuePose = poseIn;
        this.func_70296_d();
        if (refresh) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public Vector3f getRotations(ModelPart part) {
        return this.statuePose.getAngles(part);
    }

    public StatueBlock.StatueMaterial getStatueMaterial() {
        if (this.func_195044_w() != null && this.func_195044_w().func_177230_c() instanceof StatueBlock) {
            return ((StatueBlock)this.func_195044_w().func_177230_c()).getStatueMaterial();
        }
        return StatueBlock.StatueMaterial.LIMESTONE;
    }

    public boolean isStatueFemale() {
        return this.statueFemale;
    }

    public void setStatueFemale(boolean statueFemaleIn) {
        this.setStatueFemale(statueFemaleIn, false);
    }

    public void setStatueFemale(boolean statueFemaleIn, boolean refresh) {
        if (statueFemaleIn == this.statueFemale) {
            return;
        }
        this.statueFemale = statueFemaleIn;
        this.func_70296_d();
        if (refresh) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void setTextureName(String nameIn) {
        this.setTextureName(nameIn, false);
    }

    public void setTextureName(String nameIn, boolean refresh) {
        if (nameIn.equals(this.textureName)) {
            return;
        }
        this.textureName = nameIn;
        CompoundNBT profileNBT = new CompoundNBT();
        profileNBT.func_74778_a(KEY_NAME, nameIn);
        this.setPlayerProfile(NBTUtil.func_152459_a((CompoundNBT)profileNBT));
        this.func_70296_d();
        if (refresh) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public String getDeityName() {
        return this.deityName;
    }

    public void setDeityName(String deityIn) {
        this.setDeityName(deityIn, false);
    }

    public void setDeityName(String deityIn, boolean refresh) {
        this.deityName = deityIn;
        this.updateDeity();
        this.func_70296_d();
        if (refresh) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public IDeity getDeity() {
        return this.deity;
    }

    public boolean hasDeity() {
        return this.deity != null && this.deity != Deity.EMPTY;
    }

    public void updateDeity() {
        this.deity = this.deityName.isEmpty() ? Deity.EMPTY : (IDeity)GreekFantasy.PROXY.DEITY.get(new ResourceLocation(this.deityName)).orElse(Deity.EMPTY);
        this.func_70296_d();
    }

    public ItemStack handleItemInteraction(PlayerEntity player, IDeity deity, IFavor favor, ItemStack item) {
        if (!favor.isEnabled()) {
            return item;
        }
        FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
        if (GreekFantasy.CONFIG.isFlyingEnabled() && this.tryEnchant(player, deity, favor, item, "flying_enchantment", GFRegistry.FLYING_ENCHANTMENT)) {
            return item;
        }
        if (GreekFantasy.CONFIG.isLordOfTheSeaEnabled() && this.tryEnchant(player, deity, favor, item, "lord_of_the_sea_enchantment", GFRegistry.LORD_OF_THE_SEA_ENCHANTMENT)) {
            return item;
        }
        if (GreekFantasy.CONFIG.isFireflashEnabled() && this.tryEnchant(player, deity, favor, item, "fireflash_enchantment", GFRegistry.FIREFLASH_ENCHANTMENT)) {
            return item;
        }
        if (GreekFantasy.CONFIG.isRaisingEnabled() && this.tryEnchant(player, deity, favor, item, "raising_enchantment", GFRegistry.RAISING_ENCHANTMENT)) {
            return item;
        }
        if (GreekFantasy.CONFIG.isDaybreakEnabled() && this.tryEnchant(player, deity, favor, item, "daybreak_enchantment", GFRegistry.DAYBREAK_ENCHANTMENT)) {
            return item;
        }
        FavorRange range = favorConfig.getEnchantmentRange("apollo_bow");
        if (item.func_77973_b() == GFRegistry.CURSED_BOW && deity != Deity.EMPTY && deity.getName().equals((Object)range.getDeity().getName()) && range.isInFavorRange(player, favor)) {
            ItemStack bow = new ItemStack((IItemProvider)GFRegistry.APOLLO_BOW);
            bow.func_77973_b().func_77622_d(bow, player.func_130014_f_(), player);
            return bow;
        }
        range = favorConfig.getEnchantmentRange("artemis_bow");
        if (item.func_77973_b() == GFRegistry.CURSED_BOW && deity != Deity.EMPTY && deity.getName().equals((Object)range.getDeity().getName()) && range.isInFavorRange(player, favor)) {
            ItemStack bow = new ItemStack((IItemProvider)GFRegistry.ARTEMIS_BOW);
            bow.func_77973_b().func_77622_d(bow, player.func_130014_f_(), player);
            return bow;
        }
        IDeity aphrodite = GreekFantasy.PROXY.DEITY.get(new ResourceLocation("greekfantasy", "aphrodite")).orElse(Deity.EMPTY);
        IDeity athena = GreekFantasy.PROXY.DEITY.get(new ResourceLocation("greekfantasy", "athena")).orElse(Deity.EMPTY);
        IDeity hera = GreekFantasy.PROXY.DEITY.get(new ResourceLocation("greekfantasy", "hera")).orElse(Deity.EMPTY);
        if (item.func_77973_b() == GFRegistry.GOLDEN_APPLE_OF_DISCORD && deity != Deity.EMPTY && aphrodite.isEnabled() && athena.isEnabled() && hera.isEnabled()) {
            int dFavorMinus;
            int dFavor = GreekFantasy.PROXY.getFavorConfiguration().getAppleOfDiscordAmount();
            int dAphrodite = dFavorMinus = -dFavor * 5 / 4;
            int dAthena = dFavorMinus;
            int dHera = dFavorMinus;
            if (deity.getName().equals((Object)aphrodite.getName())) {
                dAphrodite = dFavor;
            } else if (deity.getName().equals((Object)athena.getName())) {
                dAthena = dFavor;
            } else if (deity.getName().equals((Object)hera.getName())) {
                dHera = dFavor;
            }
            favor.getFavor(aphrodite).addFavor(player, aphrodite, dAphrodite, FavorChangedEvent.Source.GIVE_ITEM);
            favor.getFavor(athena).addFavor(player, athena, dAthena, FavorChangedEvent.Source.GIVE_ITEM);
            favor.getFavor(hera).addFavor(player, hera, dHera, FavorChangedEvent.Source.GIVE_ITEM);
            item.func_190918_g(1);
            return item;
        }
        return item;
    }

    protected boolean tryEnchant(PlayerEntity player, IDeity deity, IFavor favor, ItemStack stack, String rangeKey, Enchantment enchant) {
        FavorRange range = GreekFantasy.PROXY.getFavorConfiguration().getEnchantmentRange(rangeKey);
        if (enchant.func_92089_a(stack) && deity != Deity.EMPTY && deity.getName().equals((Object)range.getDeity().getName()) && range.isInFavorRange(player, favor) && EnchantmentHelper.func_77506_a((Enchantment)enchant, (ItemStack)stack) < 1) {
            if (stack.func_190916_E() == 1) {
                stack.func_77966_a(enchant, 1);
                stack.func_196085_b(0);
            } else {
                ItemStack enchantedItem = stack.func_77979_a(1);
                enchantedItem.func_77966_a(enchant, 1);
                ItemEntity drop = player.func_71019_a(enchantedItem, false);
                if (drop != null) {
                    drop.func_174868_q();
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    private void setPlayerProfile(@Nullable GameProfile profile) {
        this.playerProfile = profile;
        this.updatePlayerProfile();
    }

    private void updatePlayerProfile() {
        this.playerProfile = SkullTileEntity.func_174884_b((GameProfile)this.playerProfile);
        this.func_70296_d();
    }

    public CompoundNBT func_189517_E_() {
        return this.buildUpdateTag(super.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.readUpdateTag(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.buildUpdateTag(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readUpdateTag(pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readUpdateTag(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return this.buildUpdateTag(super.func_189515_b(compound));
    }

    public CompoundNBT buildUpdateTag(CompoundNBT nbt) {
        nbt.func_74757_a(KEY_UPPER, this.upper);
        nbt.func_74757_a(KEY_FEMALE, this.statueFemale);
        nbt.func_218657_a(KEY_POSE, (INBT)this.statuePose.serializeNBT(new CompoundNBT()));
        nbt.func_218657_a(KEY_NAME, (INBT)StringNBT.func_229705_a_((String)this.textureName));
        nbt.func_218657_a(KEY_DEITY, (INBT)StringNBT.func_229705_a_((String)this.deityName));
        ItemStackHelper.func_191281_a((CompoundNBT)nbt, this.inventory, (boolean)true);
        return nbt;
    }

    public void readUpdateTag(CompoundNBT nbt) {
        this.setUpper(nbt.func_74767_n(KEY_UPPER));
        this.setStatueFemale(nbt.func_74767_n(KEY_FEMALE));
        this.setStatuePose(new StatuePose(nbt.func_74775_l(KEY_POSE)));
        this.setTextureName(nbt.func_74779_i(KEY_NAME));
        this.setDeityName(nbt.func_74779_i(KEY_DEITY));
        this.inventory.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
    }

    public void setItem(ItemStack stack, HandSide hand) {
        int i = hand.ordinal();
        this.inventory.set(i, (Object)stack);
        this.inventoryChanged();
    }

    public ItemStack getItem(HandSide hand) {
        return (ItemStack)this.inventory.get(hand.ordinal());
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    private void inventoryChanged() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void dropAllItems() {
        if (this.field_145850_b != null) {
            if (!this.field_145850_b.func_201670_d()) {
                InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), this.getInventory());
            }
            this.inventoryChanged();
        }
    }

    public void func_174888_l() {
        this.inventory.clear();
        this.inventoryChanged();
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        this.inventoryChanged();
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        this.inventoryChanged();
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.inventory.size()) {
            this.inventory.set(index, (Object)stack);
            this.inventoryChanged();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }
}

