/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import greekfantasy.GFRegistry;
import greekfantasy.GFWorldGen;
import greekfantasy.entity.DryadEntity;
import greekfantasy.entity.LampadEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public final class BiomeHelper {
    public static final ResourceLocation TAG_OLIVE_LOGS = new ResourceLocation("greekfantasy", "olive_logs");
    private static Map<RegistryKey<Biome>, DryadEntity.Variant> DRYAD_MAP = new HashMap<RegistryKey<Biome>, DryadEntity.Variant>();
    private static Map<RegistryKey<Biome>, LampadEntity.Variant> LAMPAD_MAP = new HashMap<RegistryKey<Biome>, LampadEntity.Variant>();
    private static Map<RegistryKey<Biome>, Block> LOG_MAP = new HashMap<RegistryKey<Biome>, Block>();

    private BiomeHelper() {
    }

    public static DryadEntity.Variant getDryadVariantForBiome(Optional<RegistryKey<Biome>> biome) {
        if (DRYAD_MAP.isEmpty()) {
            BiomeHelper.initDryadMap();
        }
        return biome.flatMap(b -> Optional.ofNullable(DRYAD_MAP.get(b))).orElse(DryadEntity.Variant.OAK);
    }

    public static LampadEntity.Variant getLampadVariantForBiome(Optional<RegistryKey<Biome>> biome) {
        if (LAMPAD_MAP.isEmpty()) {
            BiomeHelper.initLampadMap();
        }
        return biome.flatMap(b -> Optional.ofNullable(LAMPAD_MAP.get(b))).orElse(LampadEntity.Variant.CRIMSON);
    }

    public static BlockState getLogForBiome(Optional<RegistryKey<Biome>> biome) {
        if (LOG_MAP.isEmpty()) {
            BiomeHelper.initLogMap();
        }
        return biome.flatMap(b -> Optional.ofNullable(LOG_MAP.get(b))).orElse(Blocks.field_196617_K).func_176223_P();
    }

    public static ITag<Block> getOliveLogs() {
        return BlockTags.func_199896_a().func_199910_a(TAG_OLIVE_LOGS);
    }

    private static void initDryadMap() {
        DRYAD_MAP.clear();
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150588_X, DryadEntity.Variant.ACACIA);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150587_Y, DryadEntity.Variant.ACACIA);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185435_ag, DryadEntity.Variant.ACACIA);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185436_ah, DryadEntity.Variant.ACACIA);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150583_P, DryadEntity.Variant.BIRCH);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150582_Q, DryadEntity.Variant.BIRCH);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185448_Z, DryadEntity.Variant.BIRCH);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185429_aa, DryadEntity.Variant.BIRCH);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150585_R, DryadEntity.Variant.DARK_OAK);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185430_ab, DryadEntity.Variant.DARK_OAK);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_76782_w, DryadEntity.Variant.JUNGLE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150574_L, DryadEntity.Variant.JUNGLE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_76792_x, DryadEntity.Variant.JUNGLE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_222371_ax, DryadEntity.Variant.JUNGLE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_222370_aw, DryadEntity.Variant.JUNGLE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185446_X, DryadEntity.Variant.JUNGLE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185447_Y, DryadEntity.Variant.JUNGLE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_76768_g, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_76784_u, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150590_f, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185432_ad, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185433_ae, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150578_U, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150581_V, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_76770_e, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150580_W, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185443_S, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150577_O, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_76775_o, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150584_S, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_150579_T, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_185431_ac, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put((RegistryKey<Biome>)Biomes.field_76774_n, DryadEntity.Variant.SPRUCE);
        DRYAD_MAP.put(GFWorldGen.OLIVE_FOREST, DryadEntity.Variant.OLIVE);
    }

    private static void initLampadMap() {
        LAMPAD_MAP.clear();
        LAMPAD_MAP.put((RegistryKey<Biome>)Biomes.field_235253_az_, LampadEntity.Variant.CRIMSON);
        LAMPAD_MAP.put((RegistryKey<Biome>)Biomes.field_235250_aA_, LampadEntity.Variant.WARPED);
        LAMPAD_MAP.put((RegistryKey<Biome>)Biomes.field_235252_ay_, LampadEntity.Variant.POMEGRANATE);
    }

    private static void initLogMap() {
        LOG_MAP.clear();
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150588_X, Blocks.field_196621_O);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150587_Y, Blocks.field_196621_O);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185435_ag, Blocks.field_196621_O);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185436_ah, Blocks.field_196621_O);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150583_P, Blocks.field_196619_M);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150582_Q, Blocks.field_196619_M);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185448_Z, Blocks.field_196619_M);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185429_aa, Blocks.field_196619_M);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150585_R, Blocks.field_196623_P);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185430_ab, Blocks.field_196623_P);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_76782_w, Blocks.field_196620_N);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150574_L, Blocks.field_196620_N);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_76792_x, Blocks.field_196620_N);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_222371_ax, Blocks.field_196620_N);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_222370_aw, Blocks.field_196620_N);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185446_X, Blocks.field_196620_N);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185447_Y, Blocks.field_196620_N);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_76768_g, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_76784_u, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150590_f, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185432_ad, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185433_ae, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150578_U, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150581_V, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_76770_e, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150580_W, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185443_S, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150577_O, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_76775_o, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150584_S, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_150579_T, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_185431_ac, Blocks.field_196618_L);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_76774_n, Blocks.field_196618_L);
        LOG_MAP.put(GFWorldGen.OLIVE_FOREST, GFRegistry.OLIVE_LOG);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_235250_aA_, Blocks.field_235368_mh_);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_235253_az_, Blocks.field_235377_mq_);
        LOG_MAP.put((RegistryKey<Biome>)Biomes.field_235252_ay_, GFRegistry.POMEGRANATE_LOG);
    }
}

