/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class BiomeWhitelistConfig {
    protected final String name;
    protected final ForgeConfigSpec.IntValue spawnChance;
    protected final ForgeConfigSpec.BooleanValue whitelist;
    protected final ForgeConfigSpec.ConfigValue<List<? extends String>> spawnBiomes;

    public BiomeWhitelistConfig(ForgeConfigSpec.Builder builder, String nameIn, int weight, boolean isWhitelist, String ... biomes) {
        this.name = nameIn;
        builder.push(nameIn);
        this.spawnChance = builder.worldRestart().defineInRange("chance", weight, 0, 1000);
        this.whitelist = builder.worldRestart().define("whitelist", isWhitelist);
        this.spawnBiomes = builder.worldRestart().defineList("biome_types", (List)Lists.newArrayList((Object[])biomes), o -> o instanceof String);
        builder.pop();
    }

    public int chance() {
        return (Integer)this.spawnChance.get();
    }

    public boolean isWhitelist() {
        return (Boolean)this.whitelist.get();
    }

    public List<? extends String> biomeTypes() {
        return (List)this.spawnBiomes.get();
    }

    public boolean canSpawnInBiome(RegistryKey<Biome> biomeKey) {
        return this.isWhitelist() == this.hasBiome(biomeKey);
    }

    public boolean hasBiome(RegistryKey<Biome> biome) {
        Set types = BiomeDictionary.getTypes(biome).stream().map(t -> t.getName()).collect(Collectors.toSet());
        for (String whitelistName : (List)this.spawnBiomes.get()) {
            if (whitelistName.length() > 1 && whitelistName.contains(":") && biome.func_240901_a_().toString().equals(whitelistName)) {
                return true;
            }
            if (!types.contains(whitelistName)) continue;
            return true;
        }
        return false;
    }
}

