/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import greekfantasy.GreekFantasy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class GenericJsonReloadListener<T>
extends JsonReloadListener {
    private final Codec<T> codec;
    private final Consumer<GenericJsonReloadListener<T>> syncOnReload;
    private final Class<T> objClass;
    protected Map<ResourceLocation, Optional<T>> OBJECTS = new HashMap<ResourceLocation, Optional<T>>();

    public GenericJsonReloadListener(String folderIn, Class<T> oClass, Codec<T> oCodec, Consumer<GenericJsonReloadListener<T>> syncOnReloadConsumer) {
        super(new GsonBuilder().create(), folderIn);
        this.objClass = oClass;
        this.codec = oCodec;
        this.syncOnReload = syncOnReloadConsumer;
    }

    public void put(ResourceLocation id, @Nullable T obj) {
        this.OBJECTS.put(id, Optional.ofNullable(obj));
    }

    public Optional<T> get(ResourceLocation id) {
        return this.OBJECTS.getOrDefault(id, Optional.empty());
    }

    public Collection<Optional<T>> getValues() {
        return this.OBJECTS.values();
    }

    public Set<ResourceLocation> getKeys() {
        return this.OBJECTS.keySet();
    }

    public Set<Map.Entry<ResourceLocation, Optional<T>>> getEntries() {
        return this.OBJECTS.entrySet();
    }

    public DataResult<INBT> writeObject(T obj) {
        return this.codec.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, obj);
    }

    public DataResult<T> jsonToObject(JsonElement json) {
        return this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
    }

    public DataResult<T> readObject(INBT nbt) {
        return this.codec.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, IResourceManager manager, IProfiler profile) {
        this.OBJECTS.clear();
        GreekFantasy.LOGGER.debug("Parsing Reloadable JSON map of type " + this.objClass.getName());
        jsons.forEach((key, input) -> this.OBJECTS.put((ResourceLocation)key, this.jsonToObject((JsonElement)input).resultOrPartial(error -> GreekFantasy.LOGGER.error("Failed to read JSON object for type" + this.objClass.getName() + "\n" + error))));
        GreekFantasy.LOGGER.debug("Found " + this.OBJECTS.size() + " entries");
        boolean isServer = true;
        try {
            LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        }
        catch (Exception e) {
            isServer = false;
        }
        if (isServer) {
            this.syncOnReload.accept(this);
        }
    }
}

