/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ElpisEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.FunctionObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MysteriousBoxManager {
    private static List<ResourceLocation> functions = new ArrayList<ResourceLocation>();

    private static void loadFunctions(FunctionManager manager) {
        manager.field_240944_i_.func_240931_a_().keySet().forEach(rl -> {
            if (rl.func_110624_b().equals("greekfantasy") && rl.func_110623_a().contains("mysterious_box")) {
                functions.add((ResourceLocation)rl);
            }
        });
    }

    private static Optional<FunctionObject> getRandomFunction(FunctionManager manager, Random rand) {
        if (functions.isEmpty()) {
            MysteriousBoxManager.loadFunctions(manager);
            if (functions.isEmpty()) {
                GreekFantasy.LOGGER.error("Tried to load functions for mysterious_box but none were found! What went wrong?");
                return Optional.empty();
            }
        }
        int index = rand.nextInt(functions.size());
        ResourceLocation rl = functions.get(index);
        return manager.func_215361_a(rl);
    }

    public static boolean onBoxOpened(World worldIn, PlayerEntity playerIn, BlockState state, BlockPos pos) {
        MinecraftServer server = worldIn.func_73046_m();
        if (server != null) {
            FunctionManager manager = server.func_193030_aL();
            Optional<FunctionObject> function = MysteriousBoxManager.getRandomFunction(manager, worldIn.func_201674_k());
            Vector3d vec = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.85, (double)pos.func_177952_p() + 0.5);
            if (function.isPresent()) {
                CommandSource commandSource = manager.func_195448_f().func_197024_a((Entity)playerIn).func_201009_a(vec).func_197033_a(4).func_197031_a();
                manager.func_195447_a(function.get(), commandSource);
                if (worldIn.func_201674_k().nextInt(100) < GreekFantasy.CONFIG.getElpisSpawnChance()) {
                    MysteriousBoxManager.addElpis(worldIn, pos);
                }
                return true;
            }
        }
        return false;
    }

    public static void addElpis(World worldIn, BlockPos pos) {
        ElpisEntity entity = (ElpisEntity)GFRegistry.ELPIS_ENTITY.func_200721_a(worldIn);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.85, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
        entity.func_213390_a(pos.func_177984_a(), 8);
        worldIn.func_217376_c((Entity)entity);
    }
}

