/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class Song {
    public static final Song EMPTY = new Song("Error", "Error", 0, 0, Arrays.asList(new Integer[0]), Arrays.asList(new Integer[0]));
    public static final Codec<Song> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Song::getNameTranslationKey), (App)Codec.STRING.fieldOf("credits").forGetter(Song::getCreditsTranslationKey), (App)Codec.INT.fieldOf("interval").forGetter(Song::getInterval), (App)Codec.INT.fieldOf("length").forGetter(Song::getLength), (App)Codec.INT.listOf().fieldOf("treble").forGetter(Song::getTreble), (App)Codec.INT.listOf().fieldOf("bass").forGetter(Song::getBass)).apply((Applicative)instance, Song::new));
    private String name;
    private String credits;
    private int interval;
    private int length;
    private List<Integer> treble;
    private List<Integer> bass;

    protected Song(String lName, String lCredits, int lInterval, int lLength, List<Integer> lTreble, List<Integer> lBass) {
        this.name = lName;
        this.credits = lCredits;
        this.interval = lInterval;
        this.length = lLength;
        this.treble = lTreble;
        this.bass = lBass;
    }

    public String getNameTranslationKey() {
        return this.name;
    }

    public String getCreditsTranslationKey() {
        return this.credits;
    }

    public IFormattableTextComponent getName() {
        return new TranslationTextComponent(this.getNameTranslationKey());
    }

    public IFormattableTextComponent getCredits() {
        return new TranslationTextComponent(this.getCreditsTranslationKey()).func_240699_a_(TextFormatting.ITALIC);
    }

    public int getInterval() {
        return this.interval;
    }

    public int getLength() {
        return this.length;
    }

    public List<Integer> getTreble() {
        return this.treble;
    }

    public List<Integer> getBass() {
        return this.bass;
    }

    public boolean shouldPlayNote(long worldTime) {
        return (int)(worldTime % (long)this.getInterval()) == 0;
    }

    public List<Integer> getTrebleNotes(long worldTime) {
        return Song.getNotes(this.treble, worldTime, this.getInterval(), this.length);
    }

    public List<Integer> getBassNotes(long worldTime) {
        return Song.getNotes(this.bass, worldTime, this.getInterval(), this.length);
    }

    public static List<Integer> getNotes(List<Integer> notes, long worldTime, int playSpeed, int maxLength) {
        int currentNote;
        ArrayList<Integer> noteSet = new ArrayList<Integer>();
        int currentIndex = Math.abs((int)(worldTime / (long)playSpeed)) % maxLength;
        int n = currentNote = currentIndex >= notes.size() ? 0 : MathHelper.func_76125_a((int)notes.get(currentIndex), (int)0, (int)24);
        if (currentNote > 0) {
            noteSet.add(currentNote);
        }
        return noteSet;
    }
}

