/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import greekfantasy.GreekFantasy;
import greekfantasy.item.InstrumentItem;
import greekfantasy.util.Song;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;

public final class SongManager {
    private SongManager() {
    }

    public static boolean playMusic(LivingEntity entity, InstrumentItem instrument, ResourceLocation songName, long worldTime, float volume, float volumeBass) {
        Optional<Song> song = GreekFantasy.PROXY.PANFLUTE_SONGS.get(songName);
        if (song.isPresent() && song.get().shouldPlayNote(worldTime)) {
            List<Integer> treble = song.get().getTrebleNotes(worldTime);
            List<Integer> bass = song.get().getBassNotes(worldTime);
            for (Integer note : treble) {
                SongManager.playNoteAt(entity, instrument, note, volume);
            }
            for (Integer note : bass) {
                SongManager.playNoteAt(entity, instrument, note, volumeBass);
            }
            return !treble.isEmpty() || !bass.isEmpty();
        }
        return false;
    }

    private static void playNoteAt(LivingEntity entity, InstrumentItem instrument, int note, float volume) {
        double x = entity.func_226277_ct_() + (entity.func_70681_au().nextDouble() - 0.5) * 0.15;
        double y = entity.func_226280_cw_() + 0.15;
        double z = entity.func_226281_cx_() + (entity.func_70681_au().nextDouble() - 0.5) * 0.15;
        float pitch = instrument.getPitch(note);
        entity.func_130014_f_().func_184134_a(x, y, z, instrument.getSound(), entity.func_184176_by(), volume, pitch, false);
        entity.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197597_H, x, y, z, (double)pitch / 24.0, 0.0, 0.0);
    }
}

