/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import greekfantasy.util.ModelPart;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.common.util.INBTSerializable;

public class StatuePose
implements INBTSerializable<CompoundNBT> {
    private static final String KEY_ANGLES = "angles";
    private final EnumMap<ModelPart, Vector3f> angles = new EnumMap(ModelPart.class);

    public StatuePose() {
        this.angles.put(ModelPart.HEAD, new Vector3f(0.0f, 0.0f, 0.0f));
        this.angles.put(ModelPart.BODY, new Vector3f(0.0f, 0.0f, 0.0f));
        this.angles.put(ModelPart.LEFT_ARM, new Vector3f(0.0f, 0.0f, 0.0f));
        this.angles.put(ModelPart.RIGHT_ARM, new Vector3f(0.0f, 0.0f, 0.0f));
        this.angles.put(ModelPart.LEFT_LEG, new Vector3f(0.0f, 0.0f, 0.0f));
        this.angles.put(ModelPart.RIGHT_LEG, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public StatuePose(CompoundNBT tag) {
        this.deserializeNBT(tag);
    }

    public StatuePose set(ModelPart p, float x, float y, float z) {
        return this.setRadians(p, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public StatuePose setRadians(ModelPart p, float x, float y, float z) {
        this.angles.put(p, new Vector3f(x, y, z));
        return this;
    }

    public Vector3f getAngles(ModelPart p) {
        return this.angles.get((Object)p);
    }

    public CompoundNBT serializeNBT(CompoundNBT tag) {
        for (Map.Entry<ModelPart, Vector3f> e : this.angles.entrySet()) {
            CompoundNBT eTag = new CompoundNBT();
            eTag.func_218657_a("angles.x", (INBT)FloatNBT.func_229689_a_((float)e.getValue().func_195899_a()));
            eTag.func_218657_a("angles.y", (INBT)FloatNBT.func_229689_a_((float)e.getValue().func_195900_b()));
            eTag.func_218657_a("angles.z", (INBT)FloatNBT.func_229689_a_((float)e.getValue().func_195902_c()));
            tag.func_218657_a("angles_" + e.getKey().func_176610_l(), (INBT)eTag);
        }
        return tag;
    }

    public CompoundNBT serializeNBT() {
        return this.serializeNBT(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        for (ModelPart m : ModelPart.values()) {
            CompoundNBT eTag = nbt.func_74775_l("angles_" + m.func_176610_l());
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            if (eTag != null && !eTag.isEmpty()) {
                x = eTag.func_74760_g("angles.x");
                y = eTag.func_74760_g("angles.y");
                z = eTag.func_74760_g("angles.z");
            }
            this.angles.put(m, new Vector3f(x, y, z));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StatuePose{\n");
        for (Map.Entry<ModelPart, Vector3f> entry : this.angles.entrySet()) {
            builder.append("  ");
            builder.append(entry.getKey().func_176610_l());
            builder.append(" : ");
            builder.append(entry.getValue().toString());
            builder.append("\n");
        }
        return builder.append("}").toString();
    }
}

