/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.halloween_luckyblock.entity;

import info.u_team.halloween_luckyblock.init.HalloweenLuckyBlockEntityTypes;
import info.u_team.halloween_luckyblock.init.HalloweenLuckyBlockNetwork;
import info.u_team.halloween_luckyblock.init.HalloweenLuckyBlockSounds;
import info.u_team.halloween_luckyblock.network.MessageGhostFlash;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityGhost
extends FlyingEntity
implements IMob {
    public EntityGhost(World world) {
        this(HalloweenLuckyBlockEntityTypes.GHOST, world);
    }

    public EntityGhost(EntityType<? extends EntityGhost> type, World world) {
        super(type, world);
        this.field_70728_aV = 12;
        this.field_70765_h = new GhostMoveHelper(this);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new AIRandomFly());
        this.field_70714_bg.func_75776_a(7, (Goal)new AILookAround());
        this.field_70714_bg.func_75776_a(7, (Goal)new AIAttack());
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p_213812_1_ -> true));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    protected SoundEvent func_184639_G() {
        return HalloweenLuckyBlockSounds.SNIVELLING;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return HalloweenLuckyBlockSounds.STRANGE_LAUGHING;
    }

    protected SoundEvent func_184615_bR() {
        return HalloweenLuckyBlockSounds.THUNDER;
    }

    public float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return super.func_213380_a(worldIn, spawnReasonIn) && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 2;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.6f;
    }

    static class GhostMoveHelper
    extends MovementController {
        private final double speed = 0.25;
        private final EntityGhost parentEntity;
        private int courseChangeCooldown;

        public GhostMoveHelper(EntityGhost ghost) {
            super((MobEntity)ghost);
            this.parentEntity = ghost;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                Vec3d vec3d = new Vec3d(this.field_75646_b - this.parentEntity.field_70165_t, this.field_75647_c - this.parentEntity.field_70163_u, this.field_75644_d - this.parentEntity.field_70161_v);
                double d0 = vec3d.func_72433_c();
                if (this.func_220673_a(vec3d = vec3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vec3d.func_186678_a(0.25)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean func_220673_a(Vec3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_195586_b((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    class AIRandomFly
    extends Goal {
        private EntityGhost ghost;

        public AIRandomFly() {
            this.ghost = EntityGhost.this;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController entitymovehelper = this.ghost.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.ghost.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.ghost.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.ghost.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean continueExecuting() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.ghost.func_70681_au();
            double d0 = this.ghost.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.ghost.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.ghost.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.ghost.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    class AILookAround
    extends Goal {
        private EntityGhost ghost;

        public AILookAround() {
            this.ghost = EntityGhost.this;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.ghost.func_70638_az() == null) {
                this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)Math.atan2(this.ghost.func_213322_ci().func_82615_a(), this.ghost.func_213322_ci().func_82616_c())) * 180.0f / (float)Math.PI;
            } else {
                LivingEntity entitylivingbase = this.ghost.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.ghost) < d0 * d0) {
                    double d1 = entitylivingbase.field_70165_t - this.ghost.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.ghost.field_70161_v;
                    this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)Math.atan2(d1, d2)) * 180.0f / (float)Math.PI;
                }
            }
        }
    }

    class AIAttack
    extends Goal {
        private EntityGhost ghost;
        public int ticks;

        AIAttack() {
            this.ghost = EntityGhost.this;
        }

        public boolean func_75250_a() {
            return this.ghost.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity entitylivingbase = this.ghost.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.ghost) < d0 * d0 && this.ghost.func_70685_l((Entity)entitylivingbase)) {
                World world = this.ghost.field_70170_p;
                ++this.ticks;
                if (this.ticks == 90) {
                    world.func_184133_a(null, entitylivingbase.func_180425_c(), HalloweenLuckyBlockSounds.RINGLE, SoundCategory.HOSTILE, 1.0f, world.field_73012_v.nextFloat() * 0.8f + 0.6f);
                    entitylivingbase.func_70097_a(DamageSource.field_76376_m, 4.0f);
                    if (!world.field_72995_K && entitylivingbase instanceof ServerPlayerEntity) {
                        HalloweenLuckyBlockNetwork.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entitylivingbase), (Object)new MessageGhostFlash());
                    }
                    this.ticks = -10;
                }
            } else if (this.ticks > 0) {
                --this.ticks;
            }
        }
    }
}

