/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.halloween_luckyblock.entity;

import info.u_team.halloween_luckyblock.init.HalloweenLuckyBlockBlocks;
import info.u_team.halloween_luckyblock.init.HalloweenLuckyBlockEntityTypes;
import info.u_team.halloween_luckyblock.init.HalloweenLuckyBlockSounds;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityVampire
extends AmbientEntity {
    private static final DataParameter<Byte> HANGING = EntityDataManager.func_187226_a(EntityVampire.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final EntityPredicate field_213813_c = new EntityPredicate().func_221013_a(4.0).func_221011_b();
    private BlockPos spawnPosition;

    public EntityVampire(World worldIn) {
        this(HalloweenLuckyBlockEntityTypes.VAMPIRE, worldIn);
    }

    public EntityVampire(EntityType<? extends EntityVampire> type, World world) {
        super(type, world);
        this.setIsBatHanging(true);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new AIAttack());
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, e -> true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HANGING, (Object)0);
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    public SoundEvent func_184639_G() {
        return this.getIsBatHanging() && this.field_70146_Z.nextInt(4) != 0 ? null : SoundEvents.field_187740_w;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return HalloweenLuckyBlockSounds.SCUBI_DABI;
    }

    protected SoundEvent func_184615_bR() {
        return HalloweenLuckyBlockSounds.WIND;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity p_82167_1_) {
    }

    protected void func_85033_bc() {
    }

    public boolean getIsBatHanging() {
        return ((Byte)this.field_70180_af.func_187225_a(HANGING) & 1) != 0;
    }

    public void setIsBatHanging(boolean isHanging) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(HANGING);
        if (isHanging) {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsBatHanging()) {
            this.func_213317_d(Vec3d.field_186680_a);
            this.field_70163_u = (double)MathHelper.func_76128_c((double)this.field_70163_u) + 1.0 - (double)this.func_213302_cg();
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.getIsBatHanging()) {
            if (this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos)) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_217370_a(field_213813_c, (LivingEntity)this) != null) {
                    this.setIsBatHanging(false);
                    this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
                }
            } else {
                this.setIsBatHanging(false);
                this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
                this.spawnPosition = new BlockPos(this.field_70165_t + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.field_70163_u + (double)this.field_70146_Z.nextInt(6) - 2.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
            Vec3d vec3d = this.func_213322_ci();
            Vec3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
            if (this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos1)) {
                this.setIsBatHanging(true);
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getIsBatHanging()) {
            this.setIsBatHanging(false);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(HANGING, (Object)compound.func_74771_c("BatFlags"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("BatFlags", ((Byte)this.field_70180_af.func_187225_a(HANGING)).byteValue());
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        int j;
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (blockpos.func_177956_o() >= this.field_70170_p.func_181545_F()) {
            return false;
        }
        int i = this.field_70170_p.func_201696_r(blockpos);
        return i > this.field_70146_Z.nextInt(j = 7) ? false : super.func_213380_a(worldIn, spawnReasonIn);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b / 2.0f;
    }

    public class AIAttack
    extends Goal {
        private EntityVampire vampire;
        public int ticks;

        public AIAttack() {
            this.vampire = EntityVampire.this;
        }

        public boolean func_75250_a() {
            return this.vampire.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity entitylivingbase = this.vampire.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.vampire) < d0 * d0 && this.vampire.func_70685_l((Entity)entitylivingbase)) {
                World world = this.vampire.field_70170_p;
                ++this.ticks;
                if (this.ticks == 390) {
                    world.func_184133_a(null, this.vampire.func_180425_c(), HalloweenLuckyBlockSounds.HAPPY_HALLOWEEN, SoundCategory.NEUTRAL, 1.0f, world.field_73012_v.nextFloat() * 0.8f + 0.6f);
                    FallingBlockEntity falling = new FallingBlockEntity(world, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + 5.0, entitylivingbase.field_70161_v, HalloweenLuckyBlockBlocks.PUMPKINBOMB.func_176223_P());
                    falling.field_145812_b = 100;
                    falling.field_145813_c = false;
                    falling.func_145806_a(false);
                    world.func_217376_c((Entity)falling);
                    this.vampire.func_70665_d(DamageSource.func_76358_a((LivingEntity)entitylivingbase), 4.0f);
                    this.ticks = -10;
                }
            } else if (this.ticks > 0) {
                --this.ticks;
            }
        }
    }
}

