/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.schematic;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.BlockStateFlatteningMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class USchematicEntry {
    private ResourceLocation registryname;
    private int meta;
    private CompoundNBT nbt;

    public USchematicEntry(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        this.registryname = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        this.meta = 0;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null) {
            this.nbt = new CompoundNBT();
            tileentity.func_189515_b(this.nbt);
            this.nbt.func_82580_o("x");
            this.nbt.func_82580_o("y");
            this.nbt.func_82580_o("z");
        }
    }

    public USchematicEntry(CompoundNBT tag) {
        this.registryname = new ResourceLocation(tag.func_74779_i("name"));
        this.meta = tag.func_74762_e("meta");
        this.nbt = tag.func_74775_l("nbt");
    }

    public void setBlock(World world, BlockPos pos) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.func_208304_a((String)BlockStateFlatteningMap.func_199198_a((String)this.registryname.toString())));
        if (block == null) {
            System.err.println("Block registryname " + this.registryname + " in schematic was not found in minecraft!? Mods missing?");
            block = Blocks.field_150350_a;
        }
        BlockState state = block.func_176223_P();
        world.func_175656_a(pos, state);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null && this.nbt != null) {
            this.nbt.func_74768_a("x", pos.func_177958_n());
            this.nbt.func_74768_a("y", pos.func_177956_o());
            this.nbt.func_74768_a("z", pos.func_177952_p());
            tileentity.func_145839_a(this.nbt);
        }
    }

    public CompoundNBT getTag() {
        CompoundNBT entry = new CompoundNBT();
        entry.func_74778_a("name", this.registryname.toString());
        entry.func_74768_a("meta", this.meta);
        if (this.nbt != null) {
            entry.func_218657_a("nbt", (INBT)this.nbt);
        }
        return entry;
    }
}

