/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.schematic;

import info.u_team.u_team_core.schematic.USchematicEntry;
import info.u_team.u_team_core.schematic.USchematicRotation;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class USchematicLoadRegion {
    private World world;
    private BlockPos start;
    private int sizex;
    private int sizey;
    private int sizez;
    private boolean centerstart = false;
    private USchematicRotation rotation = USchematicRotation.ROTATION_0;

    public USchematicLoadRegion(World world, BlockPos start) {
        this.world = world;
        this.start = start;
    }

    public USchematicLoadRegion center() {
        this.centerstart = true;
        return this;
    }

    public USchematicLoadRegion rotate(USchematicRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getStart() {
        return this.start;
    }

    public void readNBT(CompoundNBT root) {
        this.sizex = root.func_74762_e("sizex");
        this.sizey = root.func_74762_e("sizey");
        this.sizez = root.func_74762_e("sizez");
        this.readBlocks(root.func_150295_c("blocks", 10));
    }

    private void readBlocks(ListNBT list) {
        if (this.centerstart) {
            this.centerstart();
        }
        ArrayList<Pair> blocks = new ArrayList<Pair>();
        int i = 0;
        for (int x = 0; x < this.sizex; ++x) {
            for (int z = 0; z < this.sizez; ++z) {
                for (int y = 0; y < this.sizey; ++y) {
                    BlockPos pos = this.start.func_177971_a((Vec3i)this.rotate(new BlockPos(x, y, z)));
                    USchematicEntry entry = new USchematicEntry(list.func_150305_b(i++));
                    blocks.add(Pair.of((Object)pos, (Object)entry));
                }
            }
        }
        int split = 30;
        int partition = blocks.size() / 30;
        for (int c = 0; c < 30; ++c) {
            int capture = c;
            this.world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(c, () -> {
                for (int index = 0; index < partition; ++index) {
                    Pair pair = (Pair)blocks.get(partition * capture + index);
                    ((USchematicEntry)pair.getRight()).setBlock(this.world, (BlockPos)pair.getLeft());
                }
            }));
        }
        int splitPortionMult = 30 * partition;
        int rest = blocks.size() - splitPortionMult;
        if (rest > 0) {
            this.world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(0, () -> {
                for (int c = 0; c < rest; ++c) {
                    Pair pair = (Pair)blocks.get(splitPortionMult + c);
                    ((USchematicEntry)pair.getRight()).setBlock(this.world, (BlockPos)pair.getLeft());
                }
            }));
        }
    }

    private void centerstart() {
        switch (this.rotation) {
            case ROTATION_0: {
                this.start = this.start.func_177973_b(new Vec3i(this.sizex / 2, 0, this.sizez / 2));
                break;
            }
            case ROTATION_90: {
                this.start = this.start.func_177973_b(new Vec3i(-this.sizez / 2, 0, this.sizex / 2));
                break;
            }
            case ROTATION_180: {
                this.start = this.start.func_177973_b(new Vec3i(-this.sizex / 2, 0, -this.sizez / 2));
                break;
            }
            case ROTATION_270: {
                this.start = this.start.func_177973_b(new Vec3i(this.sizez / 2, 0, -this.sizex / 2));
            }
        }
    }

    private BlockPos rotate(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (this.rotation) {
            case ROTATION_0: {
                return pos;
            }
            case ROTATION_90: {
                return new BlockPos(-z, y, x);
            }
            case ROTATION_180: {
                return new BlockPos(-x, y, -z);
            }
            case ROTATION_270: {
                return new BlockPos(z, y, -x);
            }
        }
        return pos;
    }
}

