/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.schematic;

import info.u_team.u_team_core.schematic.USchematicLoadRegion;
import info.u_team.u_team_core.util.io.NBTStreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;

public class USchematicReader {
    private USchematicLoadRegion region;
    private InputStream stream;
    private BiConsumer<Boolean, Long> consumer;

    public USchematicReader(USchematicLoadRegion region, File file) throws IOException {
        this(region, new FileInputStream(file));
    }

    public USchematicReader(USchematicLoadRegion region, InputStream stream) throws IOException {
        this.region = region;
        this.stream = stream;
    }

    public USchematicReader start() {
        this.startLoader();
        return this;
    }

    public USchematicReader finished(BiConsumer<Boolean, Long> consumer) {
        this.consumer = consumer;
        return this;
    }

    private void startLoader() {
        boolean success = true;
        long time = System.currentTimeMillis();
        try {
            this.region.readNBT(NBTStreamUtil.readNBTFromStream((InputStream)this.stream));
        }
        catch (IOException ex) {
            System.err.println("Error while trying to load schematic region.");
            ex.printStackTrace();
            success = false;
        }
        if (this.consumer != null) {
            this.consumer.accept(success, System.currentTimeMillis() - time);
        }
    }
}

