/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.schematic;

import info.u_team.u_team_core.schematic.USchematicEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class USchematicSaveRegion {
    private World world;
    private BlockPos min;
    private BlockPos max;
    private int sizex;
    private int sizey;
    private int sizez;
    private int count;

    public USchematicSaveRegion(World world, BlockPos pos1, BlockPos pos2) {
        this.world = world;
        this.min = new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
        this.max = new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
        this.sizex = this.max.func_177958_n() - this.min.func_177958_n() + 1;
        this.sizey = this.max.func_177956_o() - this.min.func_177956_o() + 1;
        this.sizez = this.max.func_177952_p() - this.min.func_177952_p() + 1;
        this.count = this.sizex * this.sizey * this.sizez;
    }

    public World getWorld() {
        return this.world;
    }

    public int getCount() {
        return this.count;
    }

    public BlockPos getMax() {
        return this.max;
    }

    public BlockPos getMin() {
        return this.min;
    }

    public int getSizeX() {
        return this.sizex;
    }

    public int getSizeY() {
        return this.sizey;
    }

    public int getSizeZ() {
        return this.sizez;
    }

    public CompoundNBT saveNBT() {
        CompoundNBT root = new CompoundNBT();
        root.func_74768_a("sizex", this.getSizeX());
        root.func_74768_a("sizey", this.getSizeY());
        root.func_74768_a("sizez", this.getSizeZ());
        root.func_74768_a("count", this.getCount());
        root.func_218657_a("blocks", (INBT)this.saveBlocks());
        return root;
    }

    private ListNBT saveBlocks() {
        ListNBT list = new ListNBT();
        for (int x = this.min.func_177958_n(); x <= this.max.func_177958_n(); ++x) {
            for (int z = this.min.func_177952_p(); z <= this.max.func_177952_p(); ++z) {
                for (int y = this.min.func_177956_o(); y <= this.max.func_177956_o(); ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    USchematicEntry entry = new USchematicEntry(this.world, pos);
                    list.add((Object)entry.getTag());
                }
            }
        }
        return list;
    }
}

