/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.schematic;

import info.u_team.u_team_core.schematic.USchematicSaveRegion;
import info.u_team.u_team_core.util.io.NBTStreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundNBT;

public class USchematicWriter {
    private USchematicSaveRegion region;
    private OutputStream stream;
    private BiConsumer<Boolean, Long> consumer;

    public USchematicWriter(USchematicSaveRegion region, File file) throws IOException {
        this(region, new FileOutputStream(file));
    }

    public USchematicWriter(USchematicSaveRegion region, OutputStream stream) throws IOException {
        this.region = region;
        this.stream = stream;
    }

    public USchematicWriter start() {
        this.startSaver();
        return this;
    }

    public USchematicWriter finished(BiConsumer<Boolean, Long> consumer) {
        this.consumer = consumer;
        return this;
    }

    private void startSaver() {
        Thread thread = new Thread(() -> {
            boolean success = true;
            long time = System.currentTimeMillis();
            try {
                NBTStreamUtil.writeNBTToStream((CompoundNBT)this.region.saveNBT(), (OutputStream)this.stream);
            }
            catch (IOException ex) {
                System.err.println("Error while trying to save schematic region.");
                ex.printStackTrace();
                success = false;
            }
            this.consumer.accept(success, System.currentTimeMillis() - time);
        });
        thread.setName("Schematic Saver");
        thread.start();
    }
}

