/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese;

import coffeecatrailway.hamncheese.HNCMod;
import coffeecatrailway.hamncheese.common.entity.MouseEntity;
import coffeecatrailway.hamncheese.common.entity.villager.HNCVillagerTrades;
import coffeecatrailway.hamncheese.registry.HNCEntities;
import coffeecatrailway.hamncheese.registry.HNCFeatures;
import coffeecatrailway.hamncheese.registry.HNCItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.ComposterBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="hamncheese")
public class CommonEvents {
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CommonEvents.registerCompostables();
            HNCFeatures.registerConfiguredFeatures();
        });
        HNCEntities.ATTRIBUTE_MAPS.forEach(Runnable::run);
        HNCEntities.registerSpawnPlacements();
    }

    public static void registerCompostables() {
        ComposterBlock.field_220299_b.put((Object)HNCItems.CHEESE_SLICE.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.HAM_SLICE.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.COOKED_HAM_SLICE.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.GREEN_HAM_SLICE.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.BACON.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.COOKED_BACON.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.PINEAPPLE_PLANT.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.TOMATO_SEEDS.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.CRACKED_EGG.get(), 0.4f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.COOKED_EGG.get(), 0.4f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.GREEN_EGG.get(), 0.4f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.BLOCK_OF_CHEESE.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.DOUGH.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.UNBAKED_PIZZA_BASE.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.UNBAKED_BREAD.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.BREAD_SLICE.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.TOAST.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.UNBAKED_CRACKER.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.PINEAPPLE_RING.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.PINEAPPLE_BIT.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.TOMATO_SLICE.get(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.PINEAPPLE.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)HNCItems.TOMATO.get(), 0.65f);
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        Biome.Climate climate = event.getClimate();
        if (climate.field_242461_c >= 0.5f && climate.field_242461_c < 1.0f) {
            if (((Boolean)HNCMod.COMMON_CONFIG.generateWildPineapples.get()).booleanValue()) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, HNCFeatures.WILD_PINEAPPLE_PATCH);
            }
            if (((Boolean)HNCMod.COMMON_CONFIG.generateWildTomatoes.get()).booleanValue()) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, HNCFeatures.WILD_TOMATO_PATCH);
            }
        }
        HNCEntities.addEntitySpawns(event);
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (!((Boolean)HNCMod.COMMON_CONFIG.allowFarmerTrades.get()).booleanValue()) {
            return;
        }
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() == VillagerProfession.field_221153_c) {
            ((List)trades.get(1)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.HAM_SLICE.get(), 14, 16, 2));
            ((List)trades.get(1)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.BACON.get(), 14, 16, 2));
            ((List)trades.get(2)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.COOKED_HAM_SLICE.get(), 9, 16, 5));
            ((List)trades.get(2)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.COOKED_BACON.get(), 9, 16, 5));
            ((List)trades.get(1)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.CURDLER.get(), 1, 16, 2));
            ((List)trades.get(1)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.ROLLING_PIN.get(), 1, 16, 2));
            ((List)trades.get(2)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.GRIND_STONES.get(), 1, 16, 5));
            ((List)trades.get(2)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.KNIFE.get(), 1, 8, 5));
        }
        if (event.getType() == VillagerProfession.field_221156_f) {
            ((List)trades.get(1)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.TOMATO_SEEDS.get(), 18, 16, 2));
            ((List)trades.get(1)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.PINEAPPLE_PLANT.get(), 18, 16, 2));
            ((List)trades.get(2)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.TOMATO.get(), 20, 16, 5));
            ((List)trades.get(2)).add(new HNCVillagerTrades.EmeraldForItemsTrade((IItemProvider)HNCItems.PINEAPPLE.get(), 20, 16, 5));
            ((List)trades.get(1)).add(new HNCVillagerTrades.ItemsForEmeraldsTrade((IItemProvider)HNCItems.TOMATO_SEEDS.get(), 1, 9, 16, 2));
            ((List)trades.get(1)).add(new HNCVillagerTrades.ItemsForEmeraldsTrade((IItemProvider)HNCItems.PINEAPPLE_PLANT.get(), 1, 9, 16, 2));
            ((List)trades.get(2)).add(new HNCVillagerTrades.ItemsForEmeraldsTrade((IItemProvider)HNCItems.TOMATO.get(), 2, 15, 16, 5));
            ((List)trades.get(2)).add(new HNCVillagerTrades.ItemsForEmeraldsTrade((IItemProvider)HNCItems.PINEAPPLE.get(), 2, 15, 16, 5));
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent.Throwable event) {
        if (event.getThrowable() instanceof EggEntity && event.getRayTraceResult().func_216346_c() != RayTraceResult.Type.MISS) {
            EggEntity egg = (EggEntity)event.getThrowable();
            World level = egg.field_70170_p;
            if (!level.field_72995_K && MathHelper.func_82716_a((Random)level.field_73012_v, (double)0.0, (double)1.0) <= (Double)HNCMod.SERVER_CONFIG.crackedEggSpawnChance.get()) {
                level.func_217376_c((Entity)new ItemEntity(level, egg.func_226277_ct_(), egg.func_226278_cu_(), egg.func_226281_cx_(), new ItemStack((IItemProvider)HNCItems.CRACKED_EGG.get())));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof CatEntity) {
            ((CatEntity)entity).field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)((CatEntity)entity), MouseEntity.class, false));
        }
        if (entity instanceof OcelotEntity) {
            ((OcelotEntity)entity).field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)((OcelotEntity)entity), MouseEntity.class, false));
        }
    }
}

