/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese;

import coffeecatrailway.hamncheese.ClientEvents;
import coffeecatrailway.hamncheese.CommonEvents;
import coffeecatrailway.hamncheese.HNCConfig;
import coffeecatrailway.hamncheese.datagen.HNCBlockStates;
import coffeecatrailway.hamncheese.datagen.HNCBlockTags;
import coffeecatrailway.hamncheese.datagen.HNCItemModels;
import coffeecatrailway.hamncheese.datagen.HNCItemTags;
import coffeecatrailway.hamncheese.datagen.HNCLanguage;
import coffeecatrailway.hamncheese.datagen.HNCLootTables;
import coffeecatrailway.hamncheese.datagen.HNCRecipeGen;
import coffeecatrailway.hamncheese.registry.HNCBlockPlacerTypes;
import coffeecatrailway.hamncheese.registry.HNCBlocks;
import coffeecatrailway.hamncheese.registry.HNCEntities;
import coffeecatrailway.hamncheese.registry.HNCItems;
import coffeecatrailway.hamncheese.registry.HNCRecipes;
import io.github.ocelot.lib.sonar.Sonar;
import io.github.ocelot.lib.sonar.SonarModule;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hamncheese")
public class HNCMod {
    public static final String MOD_ID = "hamncheese";
    private static final Logger LOGGER = HNCMod.getLogger("");
    public static HNCConfig.Client CLIENT_CONFIG;
    public static HNCConfig.Common COMMON_CONFIG;
    public static HNCConfig.Server SERVER_CONFIG;
    public static final ItemGroup GROUP_ALL;

    public HNCMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Sonar.init(bus, new SonarModule[0]);
        bus.addListener(ClientEvents::init);
        bus.addListener(CommonEvents::init);
        bus.addListener(this::onGatherData);
        Pair client = new ForgeConfigSpec.Builder().configure(HNCConfig.Client::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)client.getRight());
        CLIENT_CONFIG = (HNCConfig.Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(HNCConfig.Common::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)common.getRight());
        COMMON_CONFIG = (HNCConfig.Common)common.getLeft();
        Pair server = new ForgeConfigSpec.Builder().configure(HNCConfig.Server::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)server.getRight());
        SERVER_CONFIG = (HNCConfig.Server)server.getLeft();
        LOGGER.info("Register configs");
        MinecraftForge.EVENT_BUS.register((Object)this);
        HNCBlocks.load(bus);
        HNCItems.load(bus);
        HNCRecipes.load(bus);
        HNCBlockPlacerTypes.load(bus);
        HNCEntities.load(bus);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        HNCBlockTags blockTags = new HNCBlockTags(generator, existingFileHelper);
        generator.func_200390_a((IDataProvider)new HNCLanguage(generator));
        generator.func_200390_a((IDataProvider)new HNCItemTags(generator, blockTags, existingFileHelper));
        generator.func_200390_a((IDataProvider)blockTags);
        generator.func_200390_a((IDataProvider)new HNCLootTables(generator));
        generator.func_200390_a((IDataProvider)new HNCRecipeGen(generator));
        generator.func_200390_a((IDataProvider)new HNCItemModels(generator));
        generator.func_200390_a((IDataProvider)new HNCBlockStates(generator, existingFileHelper));
    }

    public static ResourceLocation getLocation(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)(MOD_ID + (!StringUtils.func_151246_b((String)name) ? "-" + name : "")));
    }

    static {
        GROUP_ALL = new ItemGroup(MOD_ID){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)HNCItems.BLOCK_OF_CHEESE.get());
            }
        };
    }
}

