/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractDoubleCropBlock
extends BushBlock
implements IGrowable {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;

    public AbstractDoubleCropBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public abstract IntegerProperty getAgeProperty();

    public abstract int getMaxAge();

    protected abstract VoxelShape[] getTopShapes();

    protected abstract VoxelShape[] getBottomShapes();

    protected abstract boolean placeableOn(BlockState var1, IBlockReader var2, BlockPos var3);

    protected abstract boolean needsFertileLand();

    protected abstract Item getPickBlock(BlockState var1);

    protected abstract void bonemeal(int var1, ServerWorld var2, BlockPos var3, BlockState var4);

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        switch ((DoubleBlockHalf)state.func_177229_b(HALF)) {
            case UPPER: {
                return this.getTopShapes()[(Integer)state.func_177229_b((Property)this.getAgeProperty())];
            }
        }
        return this.getBottomShapes()[(Integer)state.func_177229_b((Property)this.getAgeProperty())];
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.placeableOn(state, world, pos) && (world.func_180495_p(pos.func_177981_b(2)).isAir(world, pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        BlockState stateBelow = world.func_180495_p(below);
        return (world.func_226659_b_(pos, 0) >= 8 || world.func_226660_f_(pos)) && (this.func_200014_a_(stateBelow, (IBlockReader)world, below) || state.func_177230_c() == this && stateBelow.func_177230_c() == this && state.func_177229_b(HALF) == DoubleBlockHalf.UPPER && stateBelow.func_177229_b(HALF) == DoubleBlockHalf.LOWER);
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.CROP;
    }

    protected BlockState getStateForAge(int age, DoubleBlockHalf half) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age))).func_206870_a(HALF, (Comparable)half);
    }

    protected boolean isYoung(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) < this.getMaxAge();
    }

    protected float getGrowthSpeed(ServerWorld world, BlockPos pos) {
        float speed = 1.125f;
        if (world.func_226660_f_(pos)) {
            speed += 2.0f;
        }
        if (this.needsFertileLand() && (world.func_180495_p(pos.func_177977_b()).isFertile((IBlockReader)world, pos) || world.func_180495_p(pos.func_177979_c(2)).isFertile((IBlockReader)world, pos))) {
            speed *= 1.5f;
        }
        return speed;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (entity instanceof RavagerEntity && ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity)) {
            world.func_225521_a_(pos, true, entity);
        }
        super.func_196262_a(state, world, pos, entity);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.getPickBlock(state));
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean p_176473_4_) {
        return this.isYoung(state);
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        int age = (Integer)state.func_177229_b((Property)this.getAgeProperty()) + MathHelper.func_76136_a((Random)random, (int)2, (int)3);
        if (age > this.getMaxAge()) {
            age = this.getMaxAge();
        }
        this.bonemeal(age, world, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.getAgeProperty()}).func_206894_a(new Property[]{HALF});
    }
}

