/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.common.block;

import coffeecatrailway.hamncheese.common.block.AbstractDoubleCropBlock;
import coffeecatrailway.hamncheese.registry.HNCItems;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class PineapplePlantBlock
extends AbstractDoubleCropBlock {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)4);
    private static final VoxelShape[] SHAPES_TOP = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)};
    private static final VoxelShape[] SHAPES_BOTTOM = new VoxelShape[]{Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)6.0, (double)9.5), Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)8.0, (double)9.5), Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)14.0, (double)9.5), Block.func_208617_a((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5)};

    public PineapplePlantBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    @Override
    public int getMaxAge() {
        return 4;
    }

    @Override
    protected VoxelShape[] getTopShapes() {
        return SHAPES_TOP;
    }

    @Override
    protected VoxelShape[] getBottomShapes() {
        return SHAPES_BOTTOM;
    }

    @Override
    protected boolean placeableOn(BlockState state, IBlockReader world, BlockPos pos) {
        return (state.func_203425_a(Blocks.field_196658_i) || state.func_203425_a(Blocks.field_150346_d) || state.func_203425_a(Blocks.field_196660_k) || state.func_203425_a(Blocks.field_196661_l)) && !state.func_203425_a(Blocks.field_150458_ak);
    }

    @Override
    protected boolean needsFertileLand() {
        return false;
    }

    @Override
    protected Item getPickBlock(BlockState state) {
        return state.func_177229_b((Property)HALF) == DoubleBlockHalf.UPPER && !this.isYoung(state) ? (Item)HNCItems.PINEAPPLE.get() : (Item)HNCItems.PINEAPPLE_PLANT.get();
    }

    @Override
    protected void bonemeal(int age, ServerWorld world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, this.getStateForAge(age, (DoubleBlockHalf)state.func_177229_b((Property)HALF)), 2);
    }

    private void grow(BlockState state, BlockState newState, ServerWorld world, BlockPos pos, Random random) {
        float growthSpeed = this.getGrowthSpeed(world, pos);
        if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / growthSpeed) + 1) == 0 ? 1 : 0) != 0)) {
            world.func_180501_a(pos, newState, 2);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return state.func_177229_b((Property)HALF) == DoubleBlockHalf.LOWER || this.isYoung(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.func_226659_b_(pos, 0) >= 9) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b((Property)HALF);
            if (this.isYoung(state)) {
                this.grow(state, this.getStateForAge((Integer)state.func_177229_b((Property)AGE) + 1, half), world, pos, random);
            } else if (half == DoubleBlockHalf.LOWER && world.func_175623_d(pos.func_177984_a())) {
                this.grow(state, this.getStateForAge(0, DoubleBlockHalf.UPPER), world, pos.func_177984_a(), random);
            }
        }
    }
}

