/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.common.entity.ai.goal;

import coffeecatrailway.hamncheese.datagen.HNCBlockTags;
import coffeecatrailway.hamncheese.datagen.HNCItemTags;
import coffeecatrailway.hamncheese.registry.HNCItems;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FindChestWithFoodGoal
extends MoveToBlockGoal {
    private int ticker;

    public FindChestWithFoodGoal(CreatureEntity entity, double speedModifier, int searchRange, int verticalSearchRange) {
        super(entity, speedModifier, searchRange, verticalSearchRange);
    }

    public double func_203110_f() {
        return 2.0;
    }

    public boolean func_203108_i() {
        return this.field_179493_e % 20 == 0;
    }

    public boolean func_75250_a() {
        return !this.field_179495_c.func_213398_dR() && super.func_75250_a();
    }

    public void func_75249_e() {
        this.ticker = 0;
        super.func_75249_e();
    }

    public void func_75246_d() {
        if (this.func_179487_f()) {
            if (this.ticker >= 40) {
                this.eatFoodInChest(this.field_179495_c.field_70170_p, this.field_179495_c);
            } else {
                ++this.ticker;
            }
        } else if (this.field_179495_c.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
            this.field_179495_c.func_184185_a(SoundEvents.field_219628_dB, 1.0f, 1.0f);
        }
        super.func_75246_d();
    }

    private void eatFoodInChest(World world, CreatureEntity entity) {
        if (ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity)) {
            LazyOptional<IItemHandler> chestCap = this.getChest((IWorldReader)world, this.field_179494_b);
            chestCap.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack;
                    Item item;
                    if (!(world.field_73012_v.nextFloat() < 0.05f) || HNCItemTags.MOUSE_BLACKLIST.func_230235_a_((Object)(item = (stack = handler.getStackInSlot(i)).func_77973_b())) || stack.func_190926_b() || !item.func_219971_r() || item.func_219967_s() == null) continue;
                    stack = entity.func_213357_a(world, stack);
                    stack.func_190917_f(1);
                    int count = stack.func_190916_E();
                    handler.extractItem(i, count, false);
                    handler.insertItem(i, new ItemStack((IItemProvider)HNCItems.FOOD_SCRAPS.get(), world.field_73012_v.nextInt(count + 1)), false);
                    entity.func_70691_i((float)item.func_219967_s().func_221466_a() / 2.0f);
                }
            });
        }
    }

    protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
        LazyOptional<IItemHandler> chestCap = this.getChest(world, pos);
        if (chestCap.isPresent()) {
            IItemHandler handler = (IItemHandler)chestCap.orElseThrow(() -> new NullPointerException("Inventory Capability was null when present!"));
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (HNCItemTags.MOUSE_BLACKLIST.func_230235_a_((Object)stack.func_77973_b()) || stack.func_190926_b() || !stack.func_222117_E()) continue;
                return true;
            }
        }
        return false;
    }

    private LazyOptional<IItemHandler> getChest(IWorldReader world, BlockPos pos) {
        TileEntity tile;
        BlockState state = world.func_180495_p(pos);
        if (state.func_235714_a_(HNCBlockTags.MOUSE_SEARCH) && !state.func_235714_a_((ITag)Tags.Blocks.CHESTS_ENDER) && state.hasTileEntity() && (tile = world.func_175625_s(pos)) instanceof LockableLootTileEntity && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        }
        return LazyOptional.empty();
    }
}

