/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.common.item;

import coffeecatrailway.hamncheese.HNCMod;
import coffeecatrailway.hamncheese.client.item.SandwichItemRenderer;
import coffeecatrailway.hamncheese.registry.HNCFoods;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class AbstractSandwichItem
extends Item {
    public static final String TAG_INGREDIENTS = "Ingredients";
    public static final String TAG_TOASTED = "Toasted";
    public final SandwichProperties sandwichProperties;

    public AbstractSandwichItem(Item.Properties properties, SandwichProperties sandwichProperties) {
        super(properties.setISTER(() -> SandwichItemRenderer::new).func_221540_a(sandwichProperties.bunFood));
        this.sandwichProperties = sandwichProperties;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        CompoundNBT stackNbt = stack.func_196082_o();
        if (!stackNbt.func_74764_b(TAG_INGREDIENTS)) {
            stackNbt.func_218657_a(TAG_INGREDIENTS, (INBT)new ListNBT());
        }
        if (this.sandwichProperties.canBeToasted && !stackNbt.func_74764_b(TAG_TOASTED)) {
            stackNbt.func_74757_a(TAG_TOASTED, false);
        }
        return super.initCapabilities(stack, nbt);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        ListNBT ingredients = nbt.func_150295_c(TAG_INGREDIENTS, 10);
        ITextComponent name = super.func_200295_i(stack);
        if (ingredients.size() > 0) {
            name = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)ingredients.get(0))).func_200301_q().func_230532_e_().func_240702_b_(" ").func_230529_a_(super.func_200295_i(stack));
        }
        if (this.sandwichProperties.isToasted(nbt)) {
            name = new TranslationTextComponent("item.hamncheese.sandwich.toasted").func_240702_b_(" ").func_230529_a_(name);
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        List ingredients = stack.func_196082_o().func_150295_c(TAG_INGREDIENTS, 10).stream().map(nbt -> ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt)).func_77973_b()).collect(Collectors.toList());
        HashSet<Item> ingredientSet = new HashSet<Item>(ingredients);
        ingredientSet.forEach(item -> tooltip.add((ITextComponent)new ItemStack((IItemProvider)item).func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.GRAY).func_240702_b_(" x").func_240702_b_(String.valueOf(Collections.frequency(ingredients, item)))));
    }

    public boolean func_219971_r() {
        return true;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (!world.field_72995_K) {
            SoundEvent sound = SoundEvents.field_187537_bA;
            Supplier<Float> pitch = () -> Float.valueOf(1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
            entity.func_184185_a(sound, 1.0f, pitch.get().floatValue());
            world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), sound, SoundCategory.NEUTRAL, 1.0f, pitch.get().floatValue());
            Food food = this.getFood(stack);
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                player.func_71024_bL().func_75122_a(food.func_221466_a(), food.func_221469_b());
            }
            for (Pair pair : food.func_221464_f()) {
                if (pair.getFirst() == null || !(world.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                entity.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
            }
        }
        return stack;
    }

    private Food getFood(ItemStack stack) {
        ArrayList<Food> foods = new ArrayList<Food>();
        CompoundNBT nbt = stack.func_196082_o();
        Food bread = this.sandwichProperties.getBunFood(nbt);
        foods.add(bread);
        stack.func_196082_o().func_150295_c(TAG_INGREDIENTS, 10).stream().map(inbt -> ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt))).filter(ItemStack::func_222117_E).map(ingredient -> ingredient.func_77973_b().func_219967_s()).forEach(foods::add);
        if (this.sandwichProperties.hasTwoBuns()) {
            foods.add(bread);
        }
        return HNCFoods.combine(0.5f, this.sandwichProperties.isToasted(nbt), foods.toArray(new Food[0])).func_221453_d();
    }

    public static ItemStack addIngredient(ItemStack sandwich, ItemStack ingredient) {
        if (ingredient.func_222117_E() && !(ingredient.func_77973_b() instanceof AbstractSandwichItem)) {
            ItemStack added = ingredient.func_77946_l();
            added.func_190920_e(1);
            ListNBT ingredients = sandwich.func_196082_o().func_150295_c(TAG_INGREDIENTS, 10);
            if (ingredients.size() <= (Integer)HNCMod.SERVER_CONFIG.maxSandwichIngredientCraftCount.get()) {
                ingredients.add((Object)added.func_77955_b(new CompoundNBT()));
            }
        }
        return sandwich;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (!(stack1.func_77973_b() instanceof AbstractSandwichItem) || !(stack2.func_77973_b() instanceof AbstractSandwichItem)) {
            return false;
        }
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && stack1.func_77973_b() == stack2.func_77973_b();
    }

    public static class SandwichProperties {
        private final Food bunFood;
        @Nullable
        private final Food toastedBunFood;
        private final ItemStack bunItem;
        @Nullable
        private final ItemStack toastedBunItem;
        private final boolean hasTwoBuns;
        private final boolean canBeToasted;

        public SandwichProperties(Food bunFood, Supplier<? extends Item> bunItem, boolean hasTwoBuns) {
            this(bunFood, null, bunItem, null, hasTwoBuns, false);
        }

        public SandwichProperties(Food bunFood, Food toastedBunFood, Supplier<? extends Item> bunItem, Supplier<? extends Item> toastedBunItem, boolean hasTwoBuns) {
            this(bunFood, toastedBunFood, bunItem, toastedBunItem, hasTwoBuns, true);
        }

        private SandwichProperties(Food bunFood, @Nullable Food toastedBunFood, Supplier<? extends Item> bunItem, @Nullable Supplier<? extends Item> toastedBunItem, boolean hasTwoBuns, boolean canBeToasted) {
            this.bunFood = bunFood;
            this.toastedBunFood = toastedBunFood;
            this.bunItem = new ItemStack((IItemProvider)bunItem.get());
            this.toastedBunItem = toastedBunItem == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)toastedBunItem.get());
            this.hasTwoBuns = hasTwoBuns;
            this.canBeToasted = canBeToasted;
        }

        @Nullable
        public Food getBunFood(CompoundNBT nbt) {
            return this.isToasted(nbt) ? this.toastedBunFood : this.bunFood;
        }

        @Nullable
        public ItemStack getBunItem(CompoundNBT nbt) {
            return this.isToasted(nbt) ? this.toastedBunItem : this.bunItem;
        }

        public boolean hasTwoBuns() {
            return this.hasTwoBuns;
        }

        private boolean isToasted(CompoundNBT nbt) {
            return this.canBeToasted && nbt.func_74764_b(AbstractSandwichItem.TAG_TOASTED) && nbt.func_74767_n(AbstractSandwichItem.TAG_TOASTED);
        }
    }
}

