/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.common.item.crafting;

import coffeecatrailway.hamncheese.HNCMod;
import coffeecatrailway.hamncheese.common.item.AbstractSandwichItem;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class AbstractSandwichRecipe
extends SpecialRecipe {
    private final ITag.INamedTag<Item> bunTag;
    private final Supplier<? extends IItemProvider> defaultItem;

    public AbstractSandwichRecipe(ResourceLocation id, ITag.INamedTag<Item> bunTag, Supplier<? extends IItemProvider> defaultItem) {
        super(id);
        this.bunTag = bunTag;
        this.defaultItem = defaultItem;
    }

    public boolean matches(CraftingInventory inventory, World world) {
        ItemStack bunStack = this.hasBun(inventory);
        if (!bunStack.func_190926_b()) {
            AbstractSandwichItem sandwich = (AbstractSandwichItem)this.assemble(inventory).func_77973_b();
            int maxBunCount = sandwich.sandwichProperties.hasTwoBuns() ? 2 : 1;
            int bunCount = 0;
            int ingredientCount = 0;
            boolean hasNeededItem = this.getNeededItem() == null;
            int neededItemCount = 0;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (!stack.func_222117_E()) {
                    return false;
                }
                if (stack.func_77973_b() == this.getNeededItem()) {
                    hasNeededItem = ++neededItemCount <= 1;
                    continue;
                }
                if (this.bunTag.func_230235_a_((Object)stack.func_77973_b())) {
                    ++bunCount;
                    continue;
                }
                ++ingredientCount;
            }
            return bunCount == maxBunCount && ingredientCount > 0 && ingredientCount <= (Integer)HNCMod.SERVER_CONFIG.maxSandwichIngredientCraftCount.get() && hasNeededItem;
        }
        return false;
    }

    public ItemStack assemble(CraftingInventory inventory) {
        ItemStack bunStack = this.hasBun(inventory);
        if (!bunStack.func_190926_b()) {
            int neededItemCount = 0;
            ItemStack sandwich = new ItemStack(this.defaultItem.get());
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack ingredient = inventory.func_70301_a(i);
                if (ingredient.func_77973_b() == this.getNeededItem()) {
                    ++neededItemCount;
                }
                if (ingredient.func_77973_b() == this.getNeededItem() || neededItemCount > 1 || ingredient.func_190926_b() || !ingredient.func_222117_E() || this.bunTag.func_230235_a_((Object)ingredient.func_77973_b())) continue;
                sandwich = AbstractSandwichItem.addIngredient(sandwich, ingredient);
            }
            return sandwich;
        }
        return bunStack;
    }

    private ItemStack hasBun(CraftingInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ListNBT ingredients;
            ItemStack stack = inventory.func_70301_a(i);
            if (!this.bunTag.func_230235_a_((Object)stack.func_77973_b())) continue;
            if (stack.func_77973_b() instanceof AbstractSandwichItem && (ingredients = stack.func_196082_o().func_150295_c("Ingredients", 10)).size() <= 0) {
                return stack;
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nullable
    protected Item getNeededItem() {
        return null;
    }
}

