/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.datagen;

import coffeecatrailway.hamncheese.HNCMod;
import coffeecatrailway.hamncheese.registry.HNCItems;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ModelTextures;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.data.ModelsUtil;
import net.minecraft.data.StockModelShapes;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class HNCItemModels
implements IDataProvider {
    private static final Logger LOGGER = HNCMod.getLogger("ItemModels");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer;

    public HNCItemModels(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.dataGenerator.func_200391_b();
        HashMap map1 = Maps.newHashMap();
        this.consumer = (location, json) -> {
            Supplier supplier = map1.put(location, json);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + location);
            }
        };
        this.register();
        this.saveCollection(cache, path, map1, HNCItemModels::createModelPath);
    }

    private void register() {
        this.generateFlatItem((Item)HNCItems.WOODEN_GEAR.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.CURDLER.get(), StockModelShapes.field_240274_aL_);
        this.generateFlatItem((Item)HNCItems.ROLLING_PIN.get(), StockModelShapes.field_240274_aL_);
        this.generateFlatItem((Item)HNCItems.GRIND_STONES.get(), StockModelShapes.field_240274_aL_);
        this.generateFlatItem((Item)HNCItems.KNIFE.get(), StockModelShapes.field_240274_aL_);
        this.generateFlatItem((Item)HNCItems.BLOCK_OF_CHEESE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.CHEESE_SLICE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.ROCK_SALT.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.FLOUR.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.DOUGH.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.UNBAKED_PIZZA_BASE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.BAKED_PIZZA_DUMMY.get(), HNCMod.getLocation("item/pizza_base"), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.UNBAKED_BREAD.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.BREAD_SLICE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.TOAST.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.UNBAKED_CRACKER.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.CRACKER_DUMMY.get(), HNCMod.getLocation("item/cracker"), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.CRACKED_EGG.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.COOKED_EGG.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.GREEN_EGG.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.HAM_SLICE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.COOKED_HAM_SLICE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.GREEN_HAM_SLICE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.BACON.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.COOKED_BACON.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.PINEAPPLE_PLANT.get(), HNCMod.getLocation("block/pineapple_stage_0"), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.PINEAPPLE.get(), HNCMod.getLocation("block/pineapple_stage_4"), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.PINEAPPLE_RING.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.PINEAPPLE_BIT.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.TOMATO_SEEDS.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.TOMATO.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.TOMATO_SAUCE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.TOMATO_SLICE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.MOUSE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.COOKED_MOUSE.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem((Item)HNCItems.FOOD_SCRAPS.get(), StockModelShapes.field_240273_aK_);
    }

    private void generateFlatItem(Item item, ModelsUtil modelsUtil) {
        modelsUtil.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)item), ModelTextures.func_240352_b_((Item)item), this.consumer);
    }

    private void generateFlatItem(Item item, ResourceLocation texture, ModelsUtil modelsUtil) {
        modelsUtil.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)item), ModelTextures.func_240376_j_((ResourceLocation)texture), this.consumer);
    }

    private <T> void saveCollection(DirectoryCache cache, Path dataFolder, Map<T, ? extends Supplier<JsonElement>> models, BiFunction<Path, T, Path> resolver) {
        models.forEach((p_240088_3_, p_240088_4_) -> {
            Path path = (Path)resolver.apply(dataFolder, p_240088_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((JsonElement)p_240088_4_.get()), (Path)path);
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't save {}", (Object)path, (Object)exception);
            }
        });
    }

    private static Path createModelPath(Path dataFolder, ResourceLocation name) {
        return dataFolder.resolve("assets/" + name.func_110624_b() + "/models/" + name.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "hamncheese Block State Definitions";
    }
}

