/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.registry;

import coffeecatrailway.hamncheese.HNCMod;
import coffeecatrailway.hamncheese.common.entity.MouseEntity;
import coffeecatrailway.hamncheese.datagen.HNCLanguage;
import coffeecatrailway.hamncheese.registry.HNCItems;
import io.github.ocelot.lib.sonar.common.item.SpawnEggItemBase;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="hamncheese", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HNCEntities {
    private static final Logger LOGGER = HNCMod.getLogger("Entities");
    protected static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"hamncheese");
    public static final Set<Runnable> ATTRIBUTE_MAPS = new HashSet<Runnable>();
    public static final RegistryObject<EntityType<MouseEntity>> MOUSE = HNCEntities.register("mouse", MouseEntity::new, EntityClassification.AMBIENT, builder -> builder.func_220321_a(0.8f, 0.5f).func_233606_a_(10));

    private static <E extends Entity> RegistryObject<EntityType<E>> register(String id, BiFunction<EntityType<E>, World, E> entityFactory, EntityClassification classification, Function<EntityType.Builder<E>, EntityType.Builder<E>> factory) {
        RegistryObject object = ENTITIES.register(id, () -> ((EntityType.Builder)factory.apply(EntityType.Builder.func_220322_a(entityFactory::apply, (EntityClassification)classification))).func_206830_a(HNCMod.getLocation(id).toString()));
        HNCLanguage.ENTITIES.put(object, HNCLanguage.capitalize(id));
        HNCItems.registerIdAsName(id + "_spawn_egg", prop -> new SpawnEggItemBase(object, 0xFFFFFF, 8008197, true, (Item.Properties)prop));
        return object;
    }

    @SubscribeEvent
    public static void onAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)MOUSE.get(), MouseEntity.registerAttributeMap().func_233813_a_());
    }

    public static void registerSpawnPlacements() {
        if (HNCMod.SERVER_CONFIG.canSpawnMouse()) {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)MOUSE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        }
    }

    public static void addEntitySpawns(BiomeLoadingEvent event) {
        if (HNCMod.SERVER_CONFIG.canSpawnMouse()) {
            event.getSpawns().getSpawner(((EntityType)MOUSE.get()).func_220339_d()).add(new MobSpawnInfo.Spawners((EntityType)MOUSE.get(), ((Integer)HNCMod.SERVER_CONFIG.mouseSpawnWeight.get()).intValue(), ((Integer)HNCMod.SERVER_CONFIG.mouseMinCount.get()).intValue(), ((Integer)HNCMod.SERVER_CONFIG.mouseMaxCount.get()).intValue()));
        }
    }

    public static void load(IEventBus bus) {
        LOGGER.debug("Loaded");
        ENTITIES.register(bus);
    }
}

