/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.hamncheese.registry;

import coffeecatrailway.hamncheese.HNCMod;
import coffeecatrailway.hamncheese.common.item.CrackerItem;
import coffeecatrailway.hamncheese.common.item.CraftingToolItem;
import coffeecatrailway.hamncheese.common.item.GreenFoodItem;
import coffeecatrailway.hamncheese.common.item.PizzaItem;
import coffeecatrailway.hamncheese.common.item.SandwichItem;
import coffeecatrailway.hamncheese.datagen.HNCLanguage;
import coffeecatrailway.hamncheese.registry.HNCBlocks;
import coffeecatrailway.hamncheese.registry.HNCFoods;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

public class HNCItems {
    private static final Logger LOGGER = HNCMod.getLogger("Items");
    protected static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"hamncheese");
    public static final RegistryObject<Item> WOODEN_GEAR = HNCItems.registerIdAsName("wooden_gear", Item::new);
    public static final RegistryObject<CraftingToolItem> CURDLER = HNCItems.registerIdAsName("curdler", prop -> new CraftingToolItem((IItemTier)ItemTier.WOOD, 2, 2.5f, (Item.Properties)prop));
    public static final RegistryObject<CraftingToolItem> ROLLING_PIN = HNCItems.registerIdAsName("rolling_pin", prop -> new CraftingToolItem((IItemTier)ItemTier.WOOD, 1, 2.5f, (Item.Properties)prop));
    public static final RegistryObject<CraftingToolItem> GRIND_STONES = HNCItems.registerIdAsName("grind_stones", prop -> new CraftingToolItem((IItemTier)ItemTier.STONE, 2, 2.7f, (Item.Properties)prop));
    public static final RegistryObject<CraftingToolItem> KNIFE = HNCItems.registerIdAsName("knife", prop -> new CraftingToolItem((IItemTier)ItemTier.IRON, 1, 2.5f, (Item.Properties)prop));
    public static final RegistryObject<Item> BLOCK_OF_CHEESE = HNCItems.registerIdAsName("block_of_cheese", prop -> new Item(prop.func_221540_a(HNCFoods.BLOCK_OF_CHEESE).func_200917_a(16)));
    public static final RegistryObject<Item> CHEESE_SLICE = HNCItems.registerIdAsName("cheese_slice", prop -> new Item(prop.func_221540_a(HNCFoods.CHEESE_SLICE).func_200917_a(32)));
    public static final RegistryObject<Item> ROCK_SALT = HNCItems.registerIdAsName("rock_salt", prop -> new Item(prop.func_221540_a(HNCFoods.INGREDIENT)));
    public static final RegistryObject<Item> FLOUR = HNCItems.registerIdAsName("flour", prop -> new Item(prop.func_221540_a(HNCFoods.INGREDIENT)));
    public static final RegistryObject<Item> DOUGH = HNCItems.registerIdAsName("dough", prop -> new Item(prop.func_221540_a(HNCFoods.DOUGH)));
    public static final RegistryObject<Item> UNBAKED_PIZZA_BASE = HNCItems.registerIdAsName("unbaked_pizza_base", prop -> new Item(prop.func_221540_a(HNCFoods.DOUGH).func_200917_a(32)));
    public static final RegistryObject<Item> BAKED_PIZZA_DUMMY = HNCItems.registerIdAsName("baked_pizza_dummy", prop -> new Item(prop.func_221540_a(HNCFoods.PIZZA).func_200916_a(null)));
    public static final RegistryObject<PizzaItem> PIZZA = HNCItems.registerIdAsName("pizza", prop -> new PizzaItem(prop.func_200916_a(null).func_200917_a(8)));
    public static final RegistryObject<Item> UNBAKED_BREAD = HNCItems.registerIdAsName("unbaked_bread", prop -> new Item(prop.func_221540_a(HNCFoods.DOUGH)));
    public static final RegistryObject<Item> BREAD_SLICE = HNCItems.registerIdAsName("bread_slice", prop -> new Item(prop.func_221540_a(HNCFoods.BREAD_SLICE)));
    public static final RegistryObject<Item> TOAST = HNCItems.registerIdAsName("toast", prop -> new Item(prop.func_221540_a(HNCFoods.TOAST)));
    public static final RegistryObject<Item> UNBAKED_CRACKER = HNCItems.registerIdAsName("unbaked_cracker", prop -> new Item(prop.func_221540_a(HNCFoods.DOUGH).func_200917_a(16)));
    public static final RegistryObject<Item> CRACKER_DUMMY = HNCItems.registerIdAsName("cracker_dummy", prop -> new Item(prop.func_221540_a(HNCFoods.CRACKER).func_200916_a(null)));
    public static final RegistryObject<CrackerItem> CRACKER = HNCItems.registerIdAsName("cracker", prop -> new CrackerItem(prop.func_200917_a(16)));
    public static final RegistryObject<Item> CRACKED_EGG = HNCItems.registerIdAsName("cracked_egg", prop -> new Item(prop.func_221540_a(HNCFoods.CRACKED_EGG).func_200917_a(32)));
    public static final RegistryObject<Item> COOKED_EGG = HNCItems.registerIdAsName("cooked_egg", prop -> new Item(prop.func_221540_a(HNCFoods.COOKED_EGG).func_200917_a(32)));
    public static final RegistryObject<GreenFoodItem> GREEN_EGG = HNCItems.registerIdAsName("green_cracked_egg", prop -> new GreenFoodItem((Item.Properties)prop, HNCFoods.GREEN_EGG, 32));
    public static final RegistryObject<Item> HAM_SLICE = HNCItems.registerWithName("ham_slice", "Ham Slice", prop -> new Item(prop.func_221540_a(HNCFoods.HAM_SLICE).func_200917_a(32)));
    public static final RegistryObject<Item> COOKED_HAM_SLICE = HNCItems.registerIdAsName("cooked_ham_slice", prop -> new Item(prop.func_221540_a(HNCFoods.COOKED_HAM_SLICE).func_200917_a(32)));
    public static final RegistryObject<GreenFoodItem> GREEN_HAM_SLICE = HNCItems.registerIdAsName("green_ham_slice", prop -> new GreenFoodItem((Item.Properties)prop, HNCFoods.GREEN_HAM_SLICE, 32));
    public static final RegistryObject<Item> BACON = HNCItems.registerWithName("bacon", "Raw Bacon", prop -> new Item(prop.func_221540_a(HNCFoods.BACON).func_200917_a(32)));
    public static final RegistryObject<Item> COOKED_BACON = HNCItems.registerWithName("cooked_bacon", "Bacon", prop -> new Item(prop.func_221540_a(HNCFoods.COOKED_BACON).func_200917_a(32)));
    public static final RegistryObject<SandwichItem> SANDWICH = HNCItems.registerIdAsName("sandwich", prop -> new SandwichItem(prop.func_200916_a(null).func_200917_a(8)));
    public static final RegistryObject<BlockNamedItem> PINEAPPLE_PLANT = HNCItems.registerIdAsName("pineapple_plant", prop -> new BlockNamedItem((Block)HNCBlocks.PINEAPPLE_PLANT.get(), prop));
    public static final RegistryObject<Item> PINEAPPLE = HNCItems.registerIdAsName("pineapple", prop -> new Item(prop.func_221540_a(HNCFoods.PINEAPPLE).func_200917_a(16)));
    public static final RegistryObject<Item> PINEAPPLE_RING = HNCItems.registerIdAsName("pineapple_ring", prop -> new Item(prop.func_221540_a(HNCFoods.PINEAPPLE_RING).func_200917_a(32)));
    public static final RegistryObject<Item> PINEAPPLE_BIT = HNCItems.registerIdAsName("pineapple_bit", prop -> new Item(prop.func_221540_a(HNCFoods.PINEAPPLE_BIT).func_200917_a(32)));
    public static final RegistryObject<Item> TOMATO_SEEDS = HNCItems.registerIdAsName("tomato_seeds", prop -> new BlockNamedItem((Block)HNCBlocks.TOMATO_PLANT.get(), prop));
    public static final RegistryObject<Item> TOMATO = HNCItems.registerIdAsName("tomato", prop -> new Item(prop.func_221540_a(HNCFoods.TOMATO).func_200917_a(32)));
    public static final RegistryObject<Item> TOMATO_SAUCE = HNCItems.registerIdAsName("tomato_sauce", prop -> new Item(prop.func_221540_a(HNCFoods.TOMATO_SAUCE).func_200917_a(1)));
    public static final RegistryObject<Item> TOMATO_SLICE = HNCItems.registerIdAsName("tomato_slice", prop -> new Item(prop.func_221540_a(HNCFoods.TOMATO_SLICE)));
    public static final RegistryObject<Item> MOUSE = HNCItems.registerIdAsName("mouse", prop -> new Item(prop.func_221540_a(HNCFoods.MOUSE)));
    public static final RegistryObject<Item> COOKED_MOUSE = HNCItems.registerIdAsName("cooked_mouse", prop -> new Item(prop.func_221540_a(HNCFoods.COOKED_MOUSE)));
    public static final RegistryObject<Item> FOOD_SCRAPS = HNCItems.registerIdAsName("food_scraps", prop -> new Item(prop.func_221540_a(HNCFoods.FOOD_SCRAPS)));

    protected static <T extends Item> RegistryObject<T> registerIdAsName(String id, Function<Item.Properties, T> factory) {
        return HNCItems.registerWithName(id, null, factory);
    }

    private static <T extends Item> RegistryObject<T> registerWithName(String id, @Nullable String name, Function<Item.Properties, T> factory) {
        return HNCItems.register(id, name, true, factory);
    }

    private static <T extends Item> RegistryObject<T> register(String id, @Nullable String name, boolean addLang, Function<Item.Properties, T> factory) {
        RegistryObject object = ITEMS.register(id, () -> (Item)factory.apply(new Item.Properties().func_200916_a(HNCMod.GROUP_ALL)));
        if (addLang) {
            HNCLanguage.ITEMS.put((RegistryObject<? extends Item>)object, name == null ? HNCLanguage.capitalize(id) : name);
        }
        return object;
    }

    public static void load(IEventBus bus) {
        LOGGER.debug("Loaded");
        ITEMS.register(bus);
    }
}

