/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar;

import io.github.ocelot.lib.sonar.SonarModule;
import io.github.ocelot.lib.sonar.client.util.SonarDevelopmentPack;
import java.util.Arrays;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public final class Sonar {
    public static final String DOMAIN = "sonar";
    private static String parentModId;
    private static SonarModule[] modules;

    private Sonar() {
    }

    public static void init(IEventBus modBus, SonarModule ... modules) {
        parentModId = ModLoadingContext.get().getActiveNamespace();
        Sonar.modules = (SonarModule[])Arrays.stream(modules).distinct().toArray(SonarModule[]::new);
        Arrays.stream(Sonar.modules).filter(module -> !module.isClientOnly()).forEach(module -> module.init(modBus));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            SonarDevelopmentPack.init();
            Arrays.stream(modules).filter(SonarModule::isClientOnly).forEach(module -> module.init(modBus));
        });
        modBus.addListener(Sonar::setup);
        modBus.addListener(Sonar::setupClient);
    }

    private static void setup(FMLCommonSetupEvent event) {
        Arrays.stream(modules).filter(module -> !module.isClientOnly()).forEach(SonarModule::setup);
    }

    private static void setupClient(FMLClientSetupEvent event) {
        Arrays.stream(modules).filter(SonarModule::isClientOnly).forEach(SonarModule::setup);
    }

    public static boolean isModuleLoaded(SonarModule module) {
        return Arrays.stream(modules).anyMatch(m -> m == module);
    }

    public static String getParentModId() {
        return parentModId;
    }

    public static SonarModule[] getLoadedModules() {
        return modules;
    }
}

