/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar;

import io.github.ocelot.lib.sonar.common.network.inbuilt.SonarInbuiltMessages;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.eventbus.api.IEventBus;

public enum SonarModule {
    INBUILT_NETWORK(false, SonarInbuiltMessages::register, null);

    private final boolean clientOnly;
    private final Consumer<IEventBus> init;
    private final Runnable setup;

    private SonarModule(@Nullable boolean clientOnly, Consumer<IEventBus> init, Runnable setup) {
        this.clientOnly = clientOnly;
        this.init = init;
        this.setup = setup;
    }

    void init(IEventBus bus) {
        if (this.init != null) {
            this.init.accept(bus);
        }
    }

    void setup() {
        if (this.setup != null) {
            this.setup.run();
        }
    }

    public boolean isClientOnly() {
        return this.clientOnly;
    }
}

