/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ShapeRenderer {
    private static double zLevel = 0.0;
    private static float red = 1.0f;
    private static float green = 1.0f;
    private static float blue = 1.0f;
    private static float alpha = 1.0f;

    private ShapeRenderer() {
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, double x, double y, double width, double height, TextureAtlasSprite sprite) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, sprite.func_94209_e(), sprite.func_94206_g(), width, height, sprite.func_94212_f() - sprite.func_94209_e(), sprite.func_94210_h() - sprite.func_94206_g(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, double x, double y, float u, float v, double width, double height) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, (float)width, (float)height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, double x, double y, float u, float v, double width, double height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(MatrixStack matrixStack, double x, double y, float u, float v, double width, double height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        ShapeRenderer.drawRectWithTexture(ShapeRenderer.begin(), matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, sourceWidth, sourceHeight);
        ShapeRenderer.end();
    }

    public static IVertexBuilder begin() {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        return buffer;
    }

    public static void end() {
        Tessellator.func_178181_a().func_78381_a();
        zLevel = 0.0;
        ShapeRenderer.resetColor();
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, double x, double y, double width, double height, TextureAtlasSprite sprite) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, sprite.func_94209_e(), sprite.func_94206_g(), width, height, sprite.func_94212_f() - sprite.func_94209_e(), sprite.func_94210_h() - sprite.func_94206_g(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, double x, double y, float u, float v, double width, double height) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, (float)width, (float)height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, double x, double y, float u, float v, double width, double height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(IVertexBuilder buffer, MatrixStack matrixStack, double x, double y, float u, float v, double width, double height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        float scaleWidth = 1.0f / sourceWidth;
        float scaleHeight = 1.0f / sourceHeight;
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix4f, (float)x, (float)(y + height), (float)zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_(u * scaleWidth, (v + textureHeight) * scaleHeight).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)(x + width), (float)(y + height), (float)zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)(x + width), (float)y, (float)zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_((u + textureWidth) * scaleWidth, v * scaleHeight).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)x, (float)y, (float)zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_(u * scaleWidth, v * scaleHeight).func_181675_d();
    }

    public static void resetColor() {
        red = 1.0f;
        green = 1.0f;
        blue = 1.0f;
        alpha = 1.0f;
    }

    public static void setZLevel(double zLevel) {
        ShapeRenderer.zLevel = zLevel;
    }

    public static void setColor(float red, float green, float blue, float alpha) {
        ShapeRenderer.red = red;
        ShapeRenderer.green = green;
        ShapeRenderer.blue = blue;
        ShapeRenderer.alpha = alpha;
    }

    public static void setColor(int color) {
        red = (float)(color >> 16 & 0xFF) / 255.0f;
        green = (float)(color >> 8 & 0xFF) / 255.0f;
        blue = (float)(color & 0xFF) / 255.0f;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f;
    }
}

